/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class ResourceUtils {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String JAR_URL_SEPARATOR = "!/";

    public static boolean isUrl(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith(CLASSPATH_URL_PREFIX)) {
            return true;
        }
        try {
            new URL(string);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static URL getURL(String string) throws FileNotFoundException {
        Assert.notNull(string, "Resource location must not be null");
        if (string.startsWith(CLASSPATH_URL_PREFIX)) {
            String string2 = string.substring(CLASSPATH_URL_PREFIX.length());
            URL uRL = ClassUtils.getDefaultClassLoader().getResource(string2);
            if (uRL == null) {
                String string3 = "class path resource [" + string2 + "]";
                throw new FileNotFoundException(string3 + " cannot be resolved to URL because it does not exist");
            }
            return uRL;
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new URL(FILE_URL_PREFIX + string);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new FileNotFoundException("Resource location [" + string + "] is neither a URL not a well-formed file path");
            }
        }
    }

    public static File getFile(String string) throws FileNotFoundException {
        Assert.notNull(string, "Resource location must not be null");
        if (string.startsWith(CLASSPATH_URL_PREFIX)) {
            String string2 = string.substring(CLASSPATH_URL_PREFIX.length());
            String string3 = "class path resource [" + string2 + "]";
            URL uRL = ClassUtils.getDefaultClassLoader().getResource(string2);
            if (uRL == null) {
                throw new FileNotFoundException(string3 + " cannot be resolved to absolute file path " + "because it does not reside in the file system");
            }
            return ResourceUtils.getFile(uRL, string3);
        }
        try {
            return ResourceUtils.getFile(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return new File(string);
        }
    }

    public static File getFile(URL uRL) throws FileNotFoundException {
        return ResourceUtils.getFile(uRL, "URL");
    }

    public static File getFile(URL uRL, String string) throws FileNotFoundException {
        Assert.notNull(uRL, "Resource URL must not be null");
        if (!URL_PROTOCOL_FILE.equals(uRL.getProtocol())) {
            throw new FileNotFoundException(string + " cannot be resolved to absolute file path " + "because it does not reside in the file system: " + uRL);
        }
        return new File(URLDecoder.decode(uRL.getFile()));
    }

    public static boolean isJarURL(URL uRL) {
        String string = uRL.getProtocol();
        return URL_PROTOCOL_JAR.equals(string) || URL_PROTOCOL_ZIP.equals(string) || URL_PROTOCOL_WSJAR.equals(string);
    }

    public static URL extractJarFileURL(URL uRL) throws MalformedURLException {
        String string = uRL.getFile();
        int n = string.indexOf(JAR_URL_SEPARATOR);
        if (n != -1) {
            String string2 = string.substring(0, n);
            try {
                return new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                if (!string2.startsWith("/")) {
                    string2 = "/" + string2;
                }
                return new URL(FILE_URL_PREFIX + string2);
            }
        }
        return uRL;
    }
}

