/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.cmd;

import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.io.ModbusSerialTransaction;
import net.wimpi.modbus.msg.ReadMultipleRegistersRequest;
import net.wimpi.modbus.msg.ReadMultipleRegistersResponse;
import net.wimpi.modbus.net.SerialConnection;
import net.wimpi.modbus.util.SerialParameters;

public class SerialDITest {
    public static void main(String[] args1) {
        SerialConnection con = null;
        ModbusSerialTransaction trans = null;
        ReadMultipleRegistersRequest req = null;
        ReadMultipleRegistersResponse res = null;
        String[] args = new String[]{"COM1", "1", "0456", "60"};
        Object portname = null;
        int unitid = 0;
        int ref = 0;
        int count = 0;
        int repeat = 1;
        int times = 100;
        int time_i = 0;
        try {
            unitid = 1;
            ref = 275;
            count = 2;
            ModbusCoupler.getReference().setUnitID(unitid);
            System.out.println("net.wimpi.modbus.debug set to: " + System.getProperty("net.wimpi.modbus.debug"));
            SerialParameters params = new SerialParameters();
            params.setPortName("COM1");
            params.setBaudRate(19200);
            params.setDatabits(8);
            params.setParity("None");
            params.setStopbits(2);
            params.setReceiveTimeout(150);
            params.setEncoding("rtu");
            if (Modbus.debug) {
                System.out.println("Encoding [" + params.getEncoding() + "]");
            }
            con = new SerialConnection(params);
            con.open();
            while (time_i < times) {
                ++time_i;
                req = new ReadMultipleRegistersRequest(ref, count);
                req.setUnitID(unitid);
                req.setHeadless();
                if (Modbus.debug) {
                    System.out.println("Request: " + req.getHexMessage());
                }
                trans = new ModbusSerialTransaction(con);
                trans.setRequest(req);
                trans.setTransDelayMS(5);
                int k = 0;
                do {
                    try {
                        trans.execute();
                        res = (ReadMultipleRegistersResponse)trans.getResponse();
                        System.out.println("Response: " + res.getHexMessage());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println(" my error" + e.getMessage());
                    }
                } while (++k < repeat);
            }
            con.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            con.close();
        }
    }

    private static void printUsage() {
        System.out.println("java net.wimpi.modbus.cmd.SerialAITest <portname [String]>  <Unit Address [int8]> <register [int16]> <wordcount [int16]> {<repeat [int]>}");
    }
}

