/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class SocketHubAppender
extends AppenderSkeleton {
    static final int DEFAULT_PORT = 4560;
    private int port = 4560;
    private Vector oosList = new Vector();
    private ServerMonitor serverMonitor = null;
    private boolean locationInfo = false;

    public SocketHubAppender() {
    }

    public SocketHubAppender(int n) {
        this.port = n;
        this.startServer();
    }

    public void activateOptions() {
        this.startServer();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LogLog.debug("closing SocketHubAppender " + this.getName());
        this.closed = true;
        this.cleanUp();
        LogLog.debug("SocketHubAppender " + this.getName() + " closed");
    }

    public void cleanUp() {
        LogLog.debug("stopping ServerSocket");
        this.serverMonitor.stopMonitor();
        this.serverMonitor = null;
        LogLog.debug("closing client connections");
        while (this.oosList.size() != 0) {
            ObjectOutputStream objectOutputStream = (ObjectOutputStream)this.oosList.elementAt(0);
            if (objectOutputStream == null) continue;
            try {
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                LogLog.error("could not close oos.", iOException);
            }
            this.oosList.removeElementAt(0);
        }
    }

    public void append(LoggingEvent loggingEvent) {
        if (loggingEvent == null || this.oosList.size() == 0) {
            return;
        }
        if (this.locationInfo) {
            loggingEvent.getLocationInformation();
        }
        int n = 0;
        while (n < this.oosList.size()) {
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = (ObjectOutputStream)this.oosList.elementAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (objectOutputStream == null) break;
            try {
                objectOutputStream.writeObject(loggingEvent);
                objectOutputStream.flush();
                objectOutputStream.reset();
            }
            catch (IOException iOException) {
                this.oosList.removeElementAt(n);
                LogLog.debug("dropped connection");
                --n;
            }
            ++n;
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    private void startServer() {
        this.serverMonitor = new ServerMonitor(this.port, this.oosList);
    }

    private class ServerMonitor
    implements Runnable {
        private int port;
        private Vector oosList;
        private boolean keepRunning;
        private Thread monitorThread;

        public ServerMonitor(int n, Vector vector) {
            this.port = n;
            this.oosList = vector;
            this.keepRunning = true;
            this.monitorThread = new Thread(this);
            this.monitorThread.setDaemon(true);
            this.monitorThread.start();
        }

        public synchronized void stopMonitor() {
            if (this.keepRunning) {
                LogLog.debug("server monitor thread shutting down");
                this.keepRunning = false;
                try {
                    this.monitorThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.monitorThread = null;
                LogLog.debug("server monitor thread shut down");
            }
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            var1_1 = null;
            try {
                var1_1 = new ServerSocket(this.port);
                var1_1.setSoTimeout(1000);
            }
            catch (Exception var2_2) {
                LogLog.error("exception setting timeout, shutting down server socket.", var2_2);
                this.keepRunning = false;
                return;
            }
            try {
                try {
                    var1_1.setSoTimeout(1000);
                    if (true) ** GOTO lbl47
                }
                catch (SocketException var2_3) {
                    LogLog.error("exception setting timeout, shutting down server socket.", var2_3);
                    var7_5 = null;
                    try {
                        var1_1.close();
                    }
                    catch (IOException var8_8) {
                        // empty catch block
                    }
                    return;
                }
                do {
                    var2_4 = null;
                    try {
                        var2_4 = var1_1.accept();
                    }
                    catch (InterruptedIOException var3_12) {
                    }
                    catch (SocketException var4_15) {
                        LogLog.error("exception accepting socket, shutting down server socket.", var4_15);
                        this.keepRunning = false;
                    }
                    catch (IOException var5_16) {
                        LogLog.error("exception accepting socket.", var5_16);
                    }
                    if (var2_4 == null) continue;
                    try {
                        var3_11 = var2_4.getInetAddress();
                        LogLog.debug("accepting connection from " + var3_11.getHostName() + " (" + var3_11.getHostAddress() + ")");
                        var4_14 = new ObjectOutputStream(var2_4.getOutputStream());
                        this.oosList.addElement(var4_14);
                    }
                    catch (IOException var3_13) {
                        LogLog.error("exception creating output stream on socket.", var3_13);
                    }
lbl47:
                    // 4 sources

                } while (this.keepRunning);
                var7_6 = null;
            }
            catch (Throwable var6_17) {
                var7_7 = null;
                try {
                    var1_1.close();
                }
                catch (IOException var8_10) {
                    // empty catch block
                }
                throw var6_17;
            }
            try {
                var1_1.close();
            }
            catch (IOException var8_9) {}
        }
    }
}

