/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.Mergeable;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.util.StringUtils;

public class MutablePropertyValues
implements PropertyValues,
Serializable {
    private final List propertyValueList;
    private volatile boolean converted = false;

    public MutablePropertyValues() {
        this.propertyValueList = new ArrayList();
    }

    public MutablePropertyValues(PropertyValues propertyValues) {
        if (propertyValues != null) {
            PropertyValue[] propertyValueArray = propertyValues.getPropertyValues();
            this.propertyValueList = new ArrayList(propertyValueArray.length);
            for (int i = 0; i < propertyValueArray.length; ++i) {
                PropertyValue propertyValue = new PropertyValue(propertyValueArray[i]);
                this.propertyValueList.add(propertyValue);
            }
        } else {
            this.propertyValueList = new ArrayList(0);
        }
    }

    public MutablePropertyValues(Map map) {
        if (map != null) {
            this.propertyValueList = new ArrayList(map.size());
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                PropertyValue propertyValue = new PropertyValue((String)entry.getKey(), entry.getValue());
                this.propertyValueList.add(propertyValue);
            }
        } else {
            this.propertyValueList = new ArrayList(0);
        }
    }

    public MutablePropertyValues(List list) {
        this.propertyValueList = list != null ? list : new ArrayList();
    }

    public List getPropertyValueList() {
        return this.propertyValueList;
    }

    public MutablePropertyValues addPropertyValues(PropertyValues propertyValues) {
        if (propertyValues != null) {
            PropertyValue[] propertyValueArray = propertyValues.getPropertyValues();
            for (int i = 0; i < propertyValueArray.length; ++i) {
                PropertyValue propertyValue = new PropertyValue(propertyValueArray[i]);
                this.addPropertyValue(propertyValue);
            }
        }
        return this;
    }

    public MutablePropertyValues addPropertyValues(Map map) {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                PropertyValue propertyValue = new PropertyValue((String)entry.getKey(), entry.getValue());
                this.addPropertyValue(propertyValue);
            }
        }
        return this;
    }

    public MutablePropertyValues addPropertyValue(PropertyValue propertyValue) {
        for (int i = 0; i < this.propertyValueList.size(); ++i) {
            PropertyValue propertyValue2 = (PropertyValue)this.propertyValueList.get(i);
            if (!propertyValue2.getName().equals(propertyValue.getName())) continue;
            propertyValue = this.mergeIfRequired(propertyValue, propertyValue2);
            this.setPropertyValueAt(propertyValue, i);
            return this;
        }
        this.propertyValueList.add(propertyValue);
        return this;
    }

    public void addPropertyValue(String string, Object object) {
        this.addPropertyValue(new PropertyValue(string, object));
    }

    public void setPropertyValueAt(PropertyValue propertyValue, int n) {
        this.propertyValueList.set(n, propertyValue);
    }

    private PropertyValue mergeIfRequired(PropertyValue propertyValue, PropertyValue propertyValue2) {
        Mergeable mergeable;
        Object object = propertyValue.getValue();
        if (object instanceof Mergeable && (mergeable = (Mergeable)object).isMergeEnabled()) {
            Object object2 = mergeable.merge(propertyValue2.getValue());
            return new PropertyValue(propertyValue.getName(), object2);
        }
        return propertyValue;
    }

    public void removePropertyValue(String string) {
        this.removePropertyValue(this.getPropertyValue(string));
    }

    public void removePropertyValue(PropertyValue propertyValue) {
        this.propertyValueList.remove(propertyValue);
    }

    public void clear() {
        this.propertyValueList.clear();
    }

    public PropertyValue[] getPropertyValues() {
        return this.propertyValueList.toArray(new PropertyValue[this.propertyValueList.size()]);
    }

    public PropertyValue getPropertyValue(String string) {
        for (int i = 0; i < this.propertyValueList.size(); ++i) {
            PropertyValue propertyValue = (PropertyValue)this.propertyValueList.get(i);
            if (!propertyValue.getName().equals(string)) continue;
            return propertyValue;
        }
        return null;
    }

    public boolean contains(String string) {
        return this.getPropertyValue(string) != null;
    }

    public boolean isEmpty() {
        return this.propertyValueList.isEmpty();
    }

    public int size() {
        return this.propertyValueList.size();
    }

    public PropertyValues changesSince(PropertyValues propertyValues) {
        MutablePropertyValues mutablePropertyValues = new MutablePropertyValues();
        if (propertyValues == this) {
            return mutablePropertyValues;
        }
        Iterator iterator = this.propertyValueList.iterator();
        while (iterator.hasNext()) {
            PropertyValue propertyValue = (PropertyValue)iterator.next();
            PropertyValue propertyValue2 = propertyValues.getPropertyValue(propertyValue.getName());
            if (propertyValue2 == null) {
                mutablePropertyValues.addPropertyValue(propertyValue);
                continue;
            }
            if (propertyValue2.equals(propertyValue)) continue;
            mutablePropertyValues.addPropertyValue(propertyValue);
        }
        return mutablePropertyValues;
    }

    public void setConverted() {
        this.converted = true;
    }

    public boolean isConverted() {
        return this.converted;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MutablePropertyValues)) {
            return false;
        }
        MutablePropertyValues mutablePropertyValues = (MutablePropertyValues)object;
        return ((Object)this.propertyValueList).equals(mutablePropertyValues.propertyValueList);
    }

    public int hashCode() {
        return ((Object)this.propertyValueList).hashCode();
    }

    public String toString() {
        Object[] objectArray = this.getPropertyValues();
        StringBuffer stringBuffer = new StringBuffer("PropertyValues: length=" + objectArray.length + "; ");
        stringBuffer.append(StringUtils.arrayToDelimitedString((Object[])objectArray, (String)"; "));
        return stringBuffer.toString();
    }
}

