/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.Mergeable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class ConstructorArgumentValues {
    private final Map indexedArgumentValues = new HashMap();
    private final List genericArgumentValues = new LinkedList();

    public ConstructorArgumentValues() {
    }

    public ConstructorArgumentValues(ConstructorArgumentValues constructorArgumentValues) {
        this.addArgumentValues(constructorArgumentValues);
    }

    public void addArgumentValues(ConstructorArgumentValues constructorArgumentValues) {
        if (constructorArgumentValues != null) {
            Object object;
            Iterator iterator = constructorArgumentValues.indexedArgumentValues.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                ValueHolder valueHolder = (ValueHolder)object.getValue();
                this.addOrMergeIndexedArgumentValue(object.getKey(), valueHolder.copy());
            }
            iterator = constructorArgumentValues.genericArgumentValues.iterator();
            while (iterator.hasNext()) {
                object = (ValueHolder)((Object)iterator.next());
                if (this.genericArgumentValues.contains(object)) continue;
                this.genericArgumentValues.add(((ValueHolder)object).copy());
            }
        }
    }

    public void addIndexedArgumentValue(int n, Object object) {
        this.addIndexedArgumentValue(n, new ValueHolder(object));
    }

    public void addIndexedArgumentValue(int n, Object object, String string) {
        this.addIndexedArgumentValue(n, new ValueHolder(object, string));
    }

    public void addIndexedArgumentValue(int n, ValueHolder valueHolder) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0, (String)"Index must not be negative");
        Assert.notNull((Object)valueHolder, (String)"ValueHolder must not be null");
        this.addOrMergeIndexedArgumentValue(new Integer(n), valueHolder);
    }

    private void addOrMergeIndexedArgumentValue(Object object, ValueHolder valueHolder) {
        Mergeable mergeable;
        ValueHolder valueHolder2 = (ValueHolder)this.indexedArgumentValues.get(object);
        if (valueHolder2 != null && valueHolder.getValue() instanceof Mergeable && (mergeable = (Mergeable)valueHolder.getValue()).isMergeEnabled()) {
            valueHolder.setValue(mergeable.merge(valueHolder2.getValue()));
        }
        this.indexedArgumentValues.put(object, valueHolder);
    }

    public ValueHolder getIndexedArgumentValue(int n, Class clazz) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0, (String)"Index must not be negative");
        ValueHolder valueHolder = (ValueHolder)this.indexedArgumentValues.get(new Integer(n));
        if (valueHolder != null && (valueHolder.getType() == null || clazz != null && clazz.getName().equals(valueHolder.getType()))) {
            return valueHolder;
        }
        return null;
    }

    public Map getIndexedArgumentValues() {
        return Collections.unmodifiableMap(this.indexedArgumentValues);
    }

    public void addGenericArgumentValue(Object object) {
        this.genericArgumentValues.add(new ValueHolder(object));
    }

    public void addGenericArgumentValue(Object object, String string) {
        this.genericArgumentValues.add(new ValueHolder(object, string));
    }

    public void addGenericArgumentValue(ValueHolder valueHolder) {
        Assert.notNull((Object)valueHolder, (String)"ValueHolder must not be null");
        if (!this.genericArgumentValues.contains(valueHolder)) {
            this.genericArgumentValues.add(valueHolder);
        }
    }

    public ValueHolder getGenericArgumentValue(Class clazz) {
        return this.getGenericArgumentValue(clazz, null);
    }

    public ValueHolder getGenericArgumentValue(Class clazz, Set set) {
        Iterator iterator = this.genericArgumentValues.iterator();
        while (iterator.hasNext()) {
            ValueHolder valueHolder = (ValueHolder)iterator.next();
            if (set != null && set.contains(valueHolder) || !(clazz != null ? (valueHolder.getType() != null ? valueHolder.getType().equals(clazz.getName()) : ClassUtils.isAssignableValue((Class)clazz, (Object)valueHolder.getValue())) : valueHolder.getType() == null)) continue;
            return valueHolder;
        }
        return null;
    }

    public List getGenericArgumentValues() {
        return Collections.unmodifiableList(this.genericArgumentValues);
    }

    public ValueHolder getArgumentValue(int n, Class clazz) {
        return this.getArgumentValue(n, clazz, null);
    }

    public ValueHolder getArgumentValue(int n, Class clazz, Set set) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0, (String)"Index must not be negative");
        ValueHolder valueHolder = this.getIndexedArgumentValue(n, clazz);
        if (valueHolder == null) {
            valueHolder = this.getGenericArgumentValue(clazz, set);
        }
        return valueHolder;
    }

    public int getArgumentCount() {
        return this.indexedArgumentValues.size() + this.genericArgumentValues.size();
    }

    public boolean isEmpty() {
        return this.indexedArgumentValues.isEmpty() && this.genericArgumentValues.isEmpty();
    }

    public void clear() {
        this.indexedArgumentValues.clear();
        this.genericArgumentValues.clear();
    }

    public boolean equals(Object object) {
        Object object2;
        Object object3;
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConstructorArgumentValues)) {
            return false;
        }
        ConstructorArgumentValues constructorArgumentValues = (ConstructorArgumentValues)object;
        if (this.genericArgumentValues.size() != constructorArgumentValues.genericArgumentValues.size() || this.indexedArgumentValues.size() != constructorArgumentValues.indexedArgumentValues.size()) {
            return false;
        }
        Iterator iterator = this.genericArgumentValues.iterator();
        Iterator iterator2 = constructorArgumentValues.genericArgumentValues.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            object3 = (ValueHolder)iterator.next();
            if (((ValueHolder)object3).contentEquals((ValueHolder)(object2 = (ValueHolder)iterator2.next()))) continue;
            return false;
        }
        object3 = this.indexedArgumentValues.entrySet().iterator();
        while (object3.hasNext()) {
            ValueHolder valueHolder;
            object2 = (Map.Entry)object3.next();
            ValueHolder valueHolder2 = (ValueHolder)object2.getValue();
            if (valueHolder2.contentEquals(valueHolder = (ValueHolder)constructorArgumentValues.indexedArgumentValues.get(object2.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        Object object;
        int n = 7;
        Iterator<Object> iterator = this.genericArgumentValues.iterator();
        while (iterator.hasNext()) {
            object = (ValueHolder)iterator.next();
            n = 31 * n + ((ValueHolder)object).contentHashCode();
        }
        n = 29 * n;
        iterator = this.indexedArgumentValues.entrySet().iterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            Integer n2 = (Integer)object.getKey();
            ValueHolder valueHolder = (ValueHolder)object.getValue();
            n = 31 * n + (valueHolder.contentHashCode() ^ n2.hashCode());
        }
        return n;
    }

    public static class ValueHolder
    implements BeanMetadataElement {
        private Object value;
        private String type;
        private Object source;
        private boolean converted = false;
        private Object convertedValue;

        public ValueHolder(Object object) {
            this.value = object;
        }

        public ValueHolder(Object object, String string) {
            this.value = object;
            this.type = string;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public Object getValue() {
            return this.value;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        public void setSource(Object object) {
            this.source = object;
        }

        public Object getSource() {
            return this.source;
        }

        public synchronized boolean isConverted() {
            return this.converted;
        }

        public synchronized void setConvertedValue(Object object) {
            this.converted = true;
            this.convertedValue = object;
        }

        public synchronized Object getConvertedValue() {
            return this.convertedValue;
        }

        private boolean contentEquals(ValueHolder valueHolder) {
            return this == valueHolder || ObjectUtils.nullSafeEquals((Object)this.value, (Object)valueHolder.value) && ObjectUtils.nullSafeEquals((Object)this.type, (Object)valueHolder.type);
        }

        private int contentHashCode() {
            return ObjectUtils.nullSafeHashCode((Object)this.value) * 29 + ObjectUtils.nullSafeHashCode((Object)this.type);
        }

        public ValueHolder copy() {
            ValueHolder valueHolder = new ValueHolder(this.value, this.type);
            valueHolder.setSource(this.source);
            return valueHolder;
        }
    }
}

