/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class TypedStringValue
implements BeanMetadataElement {
    private String value;
    private Object targetType;
    private Object source;

    public TypedStringValue(String string) {
        this.setValue(string);
    }

    public TypedStringValue(String string, Class clazz) {
        this.setValue(string);
        this.setTargetType(clazz);
    }

    public TypedStringValue(String string, String string2) {
        this.setValue(string);
        this.setTargetTypeName(string2);
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setTargetType(Class clazz) {
        Assert.notNull((Object)clazz, (String)"'targetType' must not be null");
        this.targetType = clazz;
    }

    public Class getTargetType() {
        if (!(this.targetType instanceof Class)) {
            throw new IllegalStateException("Typed String value does not carry a resolved target type");
        }
        return (Class)this.targetType;
    }

    public void setTargetTypeName(String string) {
        Assert.notNull((Object)string, (String)"'targetTypeName' must not be null");
        this.targetType = string;
    }

    public String getTargetTypeName() {
        if (this.targetType instanceof Class) {
            return ((Class)this.targetType).getName();
        }
        return (String)this.targetType;
    }

    public boolean hasTargetType() {
        return this.targetType instanceof Class;
    }

    public Class resolveTargetType(ClassLoader classLoader) throws ClassNotFoundException {
        if (this.targetType == null) {
            return null;
        }
        Class clazz = ClassUtils.forName((String)this.getTargetTypeName(), (ClassLoader)classLoader);
        this.targetType = clazz;
        return clazz;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public Object getSource() {
        return this.source;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TypedStringValue)) {
            return false;
        }
        TypedStringValue typedStringValue = (TypedStringValue)object;
        return ObjectUtils.nullSafeEquals((Object)this.value, (Object)typedStringValue.value) && ObjectUtils.nullSafeEquals((Object)this.targetType, (Object)typedStringValue.targetType);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.value) * 29 + ObjectUtils.nullSafeHashCode((Object)this.targetType);
    }

    public String toString() {
        return "TypedStringValue: value [" + this.value + "], target type [" + this.targetType + "]";
    }
}

