/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ResourceBundleEditor
extends PropertyEditorSupport {
    public static final String BASE_NAME_SEPARATOR = "_";

    public void setAsText(String string) throws IllegalArgumentException {
        ResourceBundle resourceBundle;
        Assert.hasText((String)string, (String)"'text' must not be empty");
        String string2 = string.trim();
        int n = string2.indexOf(BASE_NAME_SEPARATOR);
        if (n == -1) {
            resourceBundle = ResourceBundle.getBundle(string2);
        } else {
            String string3 = string2.substring(0, n);
            if (!StringUtils.hasText((String)string3)) {
                throw new IllegalArgumentException("Bad ResourceBundle name : received '" + string + "' as argument to 'setAsText(String value)'.");
            }
            String string4 = string2.substring(n + 1);
            Locale locale = StringUtils.parseLocaleString((String)string4);
            resourceBundle = StringUtils.hasText((String)string4) ? ResourceBundle.getBundle(string3, locale) : ResourceBundle.getBundle(string3);
        }
        this.setValue(resourceBundle);
    }
}

