/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.console.windows;

import cn.com.voltronic.solar.beanbag.P42BeanBag;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.configure.SystemEnv;
import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.console.windows.SystemConsoleTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.dao.WorkDataDao;
import cn.com.voltronic.solar.modbusprocessor.P42ModbusProcessor;
import cn.com.voltronic.solar.protocol.P42;
import cn.com.voltronic.solar.socket.DatagramServer;
import cn.com.voltronic.solar.socket.SystemTrayUDPServer;
import cn.com.voltronic.solar.socket.UdpClient;
import cn.com.voltronic.solar.system.DaoManager;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.system.ProcessorCategories;
import cn.com.voltronic.solar.thread.AutoDetect;
import cn.com.voltronic.solar.thread.EventThread;
import cn.com.voltronic.solar.thread.PageThread;
import cn.com.voltronic.solar.upgrade.StartUpgrade;
import cn.com.voltronic.solar.util.SCcmd;
import cn.com.voltronic.solar.view.EventInfoDialog;
import cn.com.voltronic.solar.view.MainJFrame;
import cn.com.voltronic.solar.work.PollProcessorStatus;
import cn.com.voltronic.solar.work.RecordWorkinfo;
import cn.com.voltronic.solar.work.SearchDevice;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;

public class MainConsole {
    private DatagramServer udpServerSocket;
    public EventInfoDialog dialog;
    private static SolarPowerTray consoleTray = null;
    public TrayIcon trayIcon;
    public volatile List<String> infoList;
    private volatile boolean hasInfo;
    public volatile boolean isopen;
    public volatile int pvCounter;

    public static SolarPowerTray getConsoleTray() {
        return consoleTray;
    }

    public MainConsole() {
        block11: {
            this.udpServerSocket = null;
            this.dialog = null;
            this.trayIcon = null;
            this.hasInfo = false;
            this.isopen = false;
            this.pvCounter = 0;
            try {
                this.udpServerSocket = SystemTrayUDPServer.getServer();
                try {
                    this.inint();
                }
                catch (Exception e) {
                    if (this.udpServerSocket != null) {
                        this.udpServerSocket.close();
                    }
                }
            }
            catch (Exception e) {
                String port = "38694";
                UdpClient client = null;
                try {
                    try {
                        port = GlobalVariables.globalConfig.getUdpPort();
                        client = new UdpClient("localhost", port);
                        client.send("OPENPAGE");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (client != null) {
                            client.disconnect();
                        }
                    }
                }
                finally {
                    if (client == null) break block11;
                    client.disconnect();
                }
            }
        }
    }

    public void inint() {
        GlobalVariables.initConfig(Constants.CONFIG_PATH);
        this.initMonitorProcess();
        consoleTray = new SystemConsoleTray();
        EventThread event = new EventThread();
        event.start();
        SCcmd.startDaemon();
        PageThread thread = new PageThread();
        thread.start();
        this.initDaoManager();
        SearchDevice searchdevice = new SearchDevice();
        searchdevice.start();
        RecordWorkinfo record = new RecordWorkinfo();
        record.start();
        PollProcessorStatus pollstatus = new PollProcessorStatus();
        pollstatus.setPriority(10);
        pollstatus.start();
        this.trayIcon = SolarPowerTray.trayIcon;
        boolean useautoDetect = GlobalVariables.upgradeConfig.isAutoUpgrade();
        if (useautoDetect) {
            AutoDetect autoDetect = new AutoDetect();
            autoDetect.setDaemon(true);
            autoDetect.start();
        }
        this.infoList = new ArrayList<String>();
        this.responseAction();
        EventListener eventListener = new EventListener();
        eventListener.start();
    }

    public static void main(String[] args) {
        new MainConsole();
    }

    private void initDaoManager() {
        DaoManager.registerDAO(P42BeanBag.class, WorkDataDao.class);
    }

    private void initMonitorProcess() {
        ProcessorCategories.registerProcessor(P42.class, ModbusHandler.class, P42ModbusProcessor.class);
    }

    public void responseAction() {
        MouseAdapter openItemAction = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isMetaDown()) {
                    if (MainConsole.this.hasInfo) {
                        MainConsole.this.dialog = EventInfoDialog.getInstance();
                        MainConsole.this.isopen = true;
                        MainConsole.this.trayIcon.setPopupMenu(SystemConsoleTray.popup);
                        MainConsole.this.dialog.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                (this).MainConsole.this.isopen = false;
                                (this).MainConsole.this.infoList.clear();
                                (this).MainConsole.this.dialog.dispose();
                            }
                        });
                        MainConsole.this.dialog.jButton1.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent evt) {
                                (this).MainConsole.this.isopen = false;
                                (this).MainConsole.this.infoList.clear();
                                (this).MainConsole.this.dialog.dispose();
                            }
                        });
                        MainConsole.this.dialog.setVisible(true);
                        StringBuffer sb = new StringBuffer();
                        if (MainConsole.this.infoList.size() > 20) {
                            int i = MainConsole.this.infoList.size() - 20;
                            while (i < MainConsole.this.infoList.size()) {
                                sb.append(MainConsole.this.infoList.get(i));
                                ++i;
                            }
                        } else {
                            int i = 0;
                            while (i < MainConsole.this.infoList.size()) {
                                sb.append(MainConsole.this.infoList.get(i));
                                ++i;
                            }
                        }
                        MainConsole.this.dialog.getEventTextPanel().setText(sb.toString());
                        MainConsole.this.dialog.getEventTextPanel().setCaretPosition(sb.toString().length());
                        if (MainConsole.this.pvCounter > 0) {
                            MainConsole.this.trayIcon.setImage(Constants.CONNECTEDIMG_DEVICE);
                        } else {
                            MainConsole.this.trayIcon.setImage(Constants.CONNECTEDIMG);
                        }
                        MainConsole.this.hasInfo = false;
                    }
                } else if (e.getClickCount() == 2 && !e.isMetaDown() && !MainConsole.this.hasInfo) {
                    MainJFrame.getNewInstance().setVisible(true);
                    MainJFrame.getNewInstance().setState(0);
                }
            }
        };
        this.trayIcon.addMouseListener(openItemAction);
        this.trayIcon.setToolTip("SolarTracker");
    }

    class EventListener
    extends Thread {
        EventListener() {
        }

        @Override
        public void run() {
            boolean isUpgrade = false;
            block6: while (true) {
                try {
                    while (true) {
                        String rec;
                        if ((rec = MainConsole.this.udpServerSocket.receive().trim()).startsWith("(Event:")) {
                            String event = rec.substring(7, rec.lastIndexOf("13"));
                            String eventaddn = String.valueOf(event) + "\n";
                            String startEvent = eventaddn.substring(0, eventaddn.lastIndexOf("]") + 1);
                            String endEvent = eventaddn.substring(eventaddn.lastIndexOf("]") + 2);
                            MainConsole.this.infoList.add(String.valueOf(startEvent) + "\n" + "     " + endEvent);
                            if (MainConsole.this.isopen) {
                                StringBuffer sb = new StringBuffer();
                                int i = 0;
                                while (i < MainConsole.this.infoList.size()) {
                                    sb.append(MainConsole.this.infoList.get(i));
                                    ++i;
                                }
                                MainConsole.this.dialog.getEventTextPanel().setText(sb.toString());
                                MainConsole.this.dialog.getEventTextPanel().setCaretPosition(MainConsole.this.dialog.getEventTextPanel().getText().length());
                                continue;
                            }
                            if (MainConsole.this.pvCounter > 0) {
                                MainConsole.this.trayIcon.setImage(Constants.HASEVENT_DEVICE);
                            } else {
                                MainConsole.this.trayIcon.setImage(Constants.HASEVENT);
                            }
                            MainConsole.this.hasInfo = true;
                            MainConsole.this.trayIcon.setPopupMenu(null);
                            continue;
                        }
                        if (rec.startsWith("(PVCount:")) {
                            try {
                                String count = rec.substring(9);
                                MainConsole.this.pvCounter = Integer.parseInt(count);
                                if (MainConsole.this.pvCounter > 0) {
                                    if (MainConsole.this.hasInfo && !MainConsole.this.isopen) {
                                        MainConsole.this.trayIcon.setImage(Constants.HASEVENT_DEVICE);
                                        continue;
                                    }
                                    MainConsole.this.trayIcon.setImage(Constants.CONNECTEDIMG_DEVICE);
                                    continue;
                                }
                                if (MainConsole.this.hasInfo && !MainConsole.this.isopen) {
                                    MainConsole.this.trayIcon.setImage(Constants.HASEVENT);
                                    continue;
                                }
                                MainConsole.this.trayIcon.setImage(Constants.CONNECTEDIMG);
                            }
                            catch (Exception count) {}
                            continue;
                        }
                        if (rec.equals("redrawtray")) {
                            consoleTray.addToSystemTray();
                            MainConsole.this.udpServerSocket.response("redrawok");
                            continue;
                        }
                        if (rec.startsWith("(exit:myself")) {
                            SystemEnv.stoped = 0;
                            SystemEnv.stopping = true;
                            SCcmd.stopDaemon();
                            break block6;
                        }
                        if (rec.startsWith("(exit:upgrade")) {
                            isUpgrade = true;
                            SystemEnv.stoped = 0;
                            SystemEnv.stopping = true;
                            SCcmd.stopDaemon();
                            break block6;
                        }
                        if (!rec.equals("OPENPAGE")) continue;
                        MainJFrame.getNewInstance().setVisible(true);
                        MainJFrame.getNewInstance().setState(0);
                    }
                }
                catch (Exception rec) {
                    continue;
                }
                break;
            }
            if (MainConsole.this.udpServerSocket != null) {
                MainConsole.this.udpServerSocket.close();
            }
            int iexit = 0;
            while (SystemEnv.stoped < 3) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (++iexit > 20) break;
                System.out.println("stopping" + SystemEnv.stoped);
            }
            System.out.println("stopped ok");
            if (isUpgrade) {
                StartUpgrade.runUpgrade();
            }
            System.exit(0);
        }
    }
}

