/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.system;

import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.util.RunTools;

class ProtocolProcessorItem {
    private Class<?> _processorclass;
    private Class<?> _protocolclass;
    private Class<?> _handlerclass;

    public ProtocolProcessorItem(Class<?> protocolclass, Class<?> handlerclass, Class<?> processorclass) {
        this._protocolclass = protocolclass;
        this._handlerclass = handlerclass;
        this._processorclass = processorclass;
    }

    public Class<?> getProcessorclass() {
        return this._processorclass;
    }

    public Class<?> getProtocolclass() {
        return this._protocolclass;
    }

    public Class<?> getHandlerclass() {
        return this._handlerclass;
    }

    public AbstractProcessor getMatchProcess(Object handler) {
        IProtocol protocol;
        AbstractProcessor process = null;
        if (handler.getClass() == this._handlerclass && (protocol = (IProtocol)RunTools.newInstance(this._protocolclass, null)) != null && protocol.matchProtocol(handler)) {
            process = (AbstractProcessor)RunTools.newInstance(this._processorclass, new Object[]{handler, protocol});
            process.queryMachineInfo();
            process.queryConfigData();
            process.queryCapability();
            process.queryDefaultData();
        }
        return process;
    }
}

