/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.data.bean.DefaultData;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P42;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.QueryRestoreThread;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class RestoreJDialog
extends AADialog {
    private static final long serialVersionUID = 2406300060632727302L;
    private AAButton cancelButton;
    private AAButton restoreButton;
    private AALabel jLabel38;
    private AALabel jLabel39;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private IProtocol protocol;
    public DefaultData defaultData = new DefaultData();

    public RestoreJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.protocol = new P42();
        try {
            AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
            if (processor != null) {
                this.protocol = processor.getProtocol();
                this.defaultData = (DefaultData)processor.getBeanBag().getBean("defaultdata");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.protocol == null) {
            this.protocol = new P42();
        }
        this.initComponents();
        this.setTitle("message.factoryReset");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel38 = new AALabel();
        this.jLabel39 = new AALabel();
        this.restoreButton = new AAButton();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.cancelButton = new AAButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RestoreJDialog.this.closeWindows();
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel38.setIcon(new ImageIcon(Constants.WARNINGIMG));
        this.jLabel39.setText("message.noteInit");
        boolean isDisable = this.protocol.isDisable();
        this.restoreButton.setEnabled(true);
        this.restoreButton.setText("message.factoryReset");
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                RestoreJDialog.this.toRestore();
            }
        });
        this.getRestoreInfo();
        this.jPanel1.add((Component)this.jPanel3, "Center");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addGap(65, 65, 65).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel38).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel39, -1, 366, Short.MAX_VALUE)).addGroup(jPanel4Layout.createSequentialGroup().addGap(160, 160, 160).addComponent(this.restoreButton).addGap(113, 113, 113))).addGap(26, 26, 26)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.jLabel39)).addComponent(this.jLabel38)).addGap(14, 14, 14).addComponent(this.restoreButton).addContainerGap(20, Short.MAX_VALUE)));
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.cancelButton.setText("message.close");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestoreJDialog.this.closeWindows();
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(438, Short.MAX_VALUE).addComponent(this.cancelButton).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.cancelButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel2, "Last");
        this.pack();
    }

    public synchronized void closeWindows() {
        QueryRestoreThread thread = new QueryRestoreThread();
        thread.start();
        this.dispose();
    }

    private void getRestoreInfo() {
        RestoreInfo restoreInfo = this.protocol.getResotreInfo();
    }

    private void toRestore() {
        this.restoreButton.setEnabled(false);
        int re = DisplayMessage.showConfirmDialog("message.noteInit", "message.confirm");
        if (re == 0) {
            boolean result = false;
            AbstractProcessor currentProcessor = GlobalProcessors.getCurrentProcessor();
            if (currentProcessor != null) {
                result = currentProcessor.executeControl("setPF", null);
            }
            if (result) {
                if (currentProcessor != null) {
                    EventsHandler.handleEvent(currentProcessor.getProtocol().getProtocolID(), currentProcessor.getSerialNo(), new Date(), "3010");
                }
                DisplayMessage.showInfoDialog("message.setTrue");
            } else {
                DisplayMessage.showErrorDialog("message.setFalse");
            }
        }
        this.restoreButton.setEnabled(true);
    }
}

