/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view.panel;

import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RealPanel
extends JPanel {
    private static final long serialVersionUID = -7664649546219184701L;
    private JLabel aspirebg;
    private JLabel pvinput;
    private JLabel pv;
    private JLabel acinput;
    private JLabel ac;
    private JLabel output;
    private JLabel faultmode;
    private JLabel workModeV;

    public RealPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.aspirebg = new JLabel();
        this.acinput = new JLabel();
        this.ac = new JLabel();
        this.pvinput = new JLabel();
        this.pv = new JLabel();
        this.output = new JLabel();
        this.faultmode = new JLabel();
        this.workModeV = new JLabel();
        this.setLayout(null);
        this.workModeV.setText("---");
        this.add(this.workModeV);
        this.workModeV.setBounds(310, 50, 200, 15);
        this.aspirebg.setIcon(new ImageIcon(Constants.ASPIREBG));
        this.aspirebg.setBounds(10, 20, 450, 250);
        this.aspirebg.setVisible(true);
        this.pv.setIcon(new ImageIcon(Constants.PV));
        this.pv.setBounds(10, 20, 450, 250);
        this.pv.setVisible(false);
        this.ac.setIcon(new ImageIcon(Constants.AC));
        this.ac.setBounds(10, 20, 450, 250);
        this.ac.setVisible(false);
        this.acinput.setIcon(new ImageIcon(Constants.ACINPUT));
        this.acinput.setBounds(109, 124, 79, 10);
        this.acinput.setVisible(false);
        this.pvinput.setIcon(new ImageIcon(Constants.PVINPUT));
        this.pvinput.setBounds(109, 165, 79, 10);
        this.pvinput.setVisible(false);
        this.output.setIcon(new ImageIcon(Constants.OUTPUT));
        this.output.setBounds(289, 144, 79, 10);
        this.output.setVisible(false);
        this.faultmode.setIcon(new ImageIcon(Constants.FAULTMODE));
        this.faultmode.setBounds(187, 93, 103, 109);
        this.faultmode.setVisible(false);
        this.add(this.acinput);
        this.add(this.pvinput);
        this.add(this.output);
        this.add(this.faultmode);
        this.add(this.ac);
        this.add(this.pv);
        this.add(this.aspirebg);
    }

    public void setVisibleFalse() {
        this.acinput.setVisible(false);
        this.ac.setVisible(false);
        this.pvinput.setVisible(false);
        this.pv.setVisible(false);
        this.output.setVisible(false);
        this.faultmode.setVisible(false);
    }

    public void setDefaultValues() {
        this.workModeV.setText("---");
        this.acinput.setVisible(false);
        this.ac.setVisible(false);
        this.pvinput.setVisible(false);
        this.pv.setVisible(false);
        this.output.setVisible(false);
        this.faultmode.setVisible(false);
    }

    public void refreshWork(WorkInfo workInfo) {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor == null) {
            this.aspirebg.setVisible(true);
            this.setVisibleFalse();
            return;
        }
        ModbusHandler handler = (ModbusHandler)processor.getHandler();
        if (handler.getMachineType().equals("11")) {
            this.aspirebg.setVisible(false);
            if (workInfo.getWorkMode().equals("PV Mode")) {
                this.aspirebg.setVisible(false);
                this.pvinput.setVisible(true);
                this.pv.setVisible(true);
                this.acinput.setVisible(false);
                this.ac.setVisible(false);
            } else if (workInfo.getWorkMode().equals("Line Mode")) {
                this.aspirebg.setVisible(false);
                this.pvinput.setVisible(false);
                this.pv.setVisible(false);
                this.acinput.setVisible(true);
                this.ac.setVisible(true);
            } else {
                this.aspirebg.setVisible(true);
                this.pvinput.setVisible(false);
                this.pv.setVisible(false);
                this.acinput.setVisible(false);
                this.ac.setVisible(false);
            }
        } else {
            this.aspirebg.setVisible(false);
            if (workInfo.getInputSource() == 0) {
                this.aspirebg.setVisible(false);
                this.pvinput.setVisible(true);
                this.pv.setVisible(true);
                this.acinput.setVisible(false);
                this.ac.setVisible(false);
            } else if (workInfo.getInputSource() == 1) {
                this.aspirebg.setVisible(false);
                this.pvinput.setVisible(false);
                this.pv.setVisible(false);
                this.acinput.setVisible(true);
                this.ac.setVisible(true);
            } else {
                this.aspirebg.setVisible(true);
                this.pvinput.setVisible(false);
                this.pv.setVisible(false);
                this.acinput.setVisible(false);
                this.ac.setVisible(false);
            }
        }
        String workMode = workInfo.getWorkMode();
        this.workModeV.setText(workMode);
        if (workInfo.isHasFault()) {
            this.faultmode.setVisible(true);
        } else {
            this.faultmode.setVisible(false);
        }
        if (workMode.equals("Power On Mode")) {
            this.showPowerOnMode(workInfo);
        } else if (workMode.equals("Standby Mode")) {
            this.showStandbyMode(workInfo);
        } else if (workMode.equals("Output Mode")) {
            this.showOutputMode(workInfo);
        } else if (workMode.equals("Fault Mode")) {
            this.showFaultMode(workInfo);
        } else if (workMode.equals("Shutdown Mode")) {
            this.showShutdownMode(workInfo);
        } else if (workMode.equals("PV Mode")) {
            this.showPVMode(workInfo);
        } else if (workMode.equals("Line Mode")) {
            this.showLineMode(workInfo);
        }
    }

    private void showPowerOnMode(WorkInfo workInfo) {
        this.pvinput.setVisible(false);
        this.acinput.setVisible(false);
        this.output.setVisible(false);
    }

    private void showStandbyMode(WorkInfo workInfo) {
        this.output.setVisible(false);
    }

    private void showOutputMode(WorkInfo workInfo) {
        this.output.setVisible(true);
    }

    private void showFaultMode(WorkInfo workInfo) {
        this.showStandbyMode(workInfo);
    }

    private void showShutdownMode(WorkInfo workInfo) {
        this.showOutputMode(workInfo);
    }

    private void showPVMode(WorkInfo workInfo) {
        this.pvinput.setVisible(true);
        this.acinput.setVisible(false);
        this.output.setVisible(true);
    }

    private void showLineMode(WorkInfo workInfo) {
        this.pvinput.setVisible(false);
        this.acinput.setVisible(true);
        this.output.setVisible(true);
    }
}

