/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view.panel;

import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.ProductInfo;
import cn.com.voltronic.solar.data.bean.RatingInfo;
import cn.com.voltronic.solar.data.bean.RefreshProductInfo;
import cn.com.voltronic.solar.data.bean.RefreshRatingInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P42;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.PageUtils;
import cn.com.voltronic.solar.view.component.AATitleBorder;
import cn.com.voltronic.solar.view.panel.BasePanel;
import cn.com.voltronic.solar.view.panel.RealPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class StatusPanel
extends JSplitPane {
    private static final long serialVersionUID = -8507396759503040868L;
    private JPanel topPanel;
    public RealPanel realPanel;
    public JScrollPane baseJSPanel;
    public BasePanel basePanel;
    public JPanel centerPanel;
    public JPanel productPanel;
    public JPanel ratingPanel;
    public JScrollPane ratingJPanel;
    private JScrollPane topScrollPane;
    private JScrollPane centerScrollPane;
    public MachineInfo machineInfo = new MachineInfo();
    private IProtocol protocol;
    private List<RefreshRatingInfo> ratingList = new ArrayList<RefreshRatingInfo>();
    private List<RefreshProductInfo> productList = new ArrayList<RefreshProductInfo>();

    public StatusPanel() {
        this.protocol = new P42();
        try {
            AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
            this.protocol = processor.getProtocol();
            this.machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.protocol == null) {
            this.protocol = new P42();
        }
        this.initCompents();
    }

    private void initCompents() {
        this.topScrollPane = new JScrollPane();
        this.topPanel = new JPanel();
        this.realPanel = new RealPanel();
        this.basePanel = new BasePanel();
        this.centerScrollPane = new JScrollPane();
        this.centerPanel = new JPanel();
        this.productPanel = new JPanel();
        this.ratingPanel = new JPanel();
        this.setDividerLocation(380);
        this.setOrientation(0);
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)this.realPanel, "Center");
        this.baseJSPanel = new JScrollPane();
        this.baseJSPanel.setPreferredSize(new Dimension(510, 200));
        this.baseJSPanel.setViewportView(this.basePanel);
        this.topPanel.add((Component)this.baseJSPanel, "East");
        this.topScrollPane.setViewportView(this.topPanel);
        this.setTopComponent(this.topScrollPane);
        this.centerPanel.setLayout(new BorderLayout());
        this.getProductInfo();
        this.getRatingInfo();
        this.centerPanel.add((Component)this.productPanel, "Center");
        this.ratingJPanel = new JScrollPane();
        this.ratingJPanel.setPreferredSize(new Dimension(510, 200));
        this.ratingJPanel.setViewportView(this.ratingPanel);
        this.centerPanel.add((Component)this.ratingJPanel, "East");
        this.centerScrollPane.setViewportView(this.centerPanel);
        this.setBottomComponent(this.centerScrollPane);
    }

    public void getProductInfo() {
        this.productPanel.setBorder(new AATitleBorder("message.productinfo"));
        ProductInfo productInfo = this.protocol.getProductInfo();
        List<AutoLabelItem> list = productInfo.getInfos();
        this.productList = PageUtils.setInfoLayout(list, this.productPanel, this);
    }

    public void getRatingInfo() {
        this.ratingPanel.setBorder(new AATitleBorder("message.ratinginfo"));
        RatingInfo ratingInfo = this.protocol.getRatingInfo();
        List<AutoLabelItem> list = ratingInfo.getInfos();
        this.ratingList = PageUtils.setRatingLayout(list, this.ratingPanel, this);
    }

    public void setDefaultValues() {
        int i = 0;
        while (i < this.productList.size()) {
            this.productList.get(i).getTextField().setText("---");
            ++i;
        }
        i = 0;
        while (i < this.ratingList.size()) {
            this.ratingList.get(i).getTextField().setText("0.0");
            ++i;
        }
    }

    public synchronized void refreshMachineInfo(MachineInfo machineInfo) {
        this.machineInfo = machineInfo;
        int i = 0;
        while (i < this.productList.size()) {
            this.productList.get(i).getTextField().setText(PageUtils.getResultByName(this.productList.get(i).getValue(), this));
            ++i;
        }
        i = 0;
        while (i < this.ratingList.size()) {
            this.ratingList.get(i).getTextField().setText(PageUtils.getResultByName(this.ratingList.get(i).getValue(), this));
            ++i;
        }
    }
}

