/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderImpl;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import com.sun.org.apache.xerces.internal.util.SAXMessageFormatter;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DocumentBuilderFactoryImpl
extends DocumentBuilderFactory {
    private Hashtable attributes;
    private Hashtable features;
    private Schema grammar;
    private boolean isXIncludeAware;
    private boolean fSecureProcess = true;

    @Override
    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        if (this.grammar != null && this.attributes != null) {
            if (this.attributes.containsKey("http://java.sun.com/xml/jaxp/properties/schemaLanguage")) {
                throw new ParserConfigurationException(SAXMessageFormatter.formatMessage(null, "schema-already-specified", new Object[]{"http://java.sun.com/xml/jaxp/properties/schemaLanguage"}));
            }
            if (this.attributes.containsKey("http://java.sun.com/xml/jaxp/properties/schemaSource")) {
                throw new ParserConfigurationException(SAXMessageFormatter.formatMessage(null, "schema-already-specified", new Object[]{"http://java.sun.com/xml/jaxp/properties/schemaSource"}));
            }
        }
        try {
            return new DocumentBuilderImpl(this, this.attributes, this.features, this.fSecureProcess);
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException(sAXException.getMessage());
        }
    }

    @Override
    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (object == null) {
            if (this.attributes != null) {
                this.attributes.remove(string);
            }
            return;
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, object);
        try {
            new DocumentBuilderImpl(this, this.attributes, this.features);
        }
        catch (Exception exception) {
            this.attributes.remove(string);
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    @Override
    public Object getAttribute(String string) throws IllegalArgumentException {
        DOMParser dOMParser;
        if (this.attributes != null && (dOMParser = (DOMParser)this.attributes.get(string)) != null) {
            return dOMParser;
        }
        dOMParser = null;
        try {
            dOMParser = new DocumentBuilderImpl(this, this.attributes, this.features).getDOMParser();
            return dOMParser.getProperty(string);
        }
        catch (SAXException sAXException) {
            try {
                boolean bl = dOMParser.getFeature(string);
                return bl ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (SAXException sAXException2) {
                throw new IllegalArgumentException(sAXException.getMessage());
            }
        }
    }

    @Override
    public Schema getSchema() {
        return this.grammar;
    }

    @Override
    public void setSchema(Schema schema) {
        this.grammar = schema;
    }

    @Override
    public boolean isXIncludeAware() {
        return this.isXIncludeAware;
    }

    @Override
    public void setXIncludeAware(boolean bl) {
        this.isXIncludeAware = bl;
    }

    @Override
    public boolean getFeature(String string) throws ParserConfigurationException {
        Object object;
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.fSecureProcess;
        }
        if (this.features != null && (object = this.features.get(string)) != null) {
            return (Boolean)object;
        }
        try {
            object = new DocumentBuilderImpl(this, this.attributes, this.features).getDOMParser();
            return ((DOMParser)object).getFeature(string);
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException(sAXException.getMessage());
        }
    }

    @Override
    public void setFeature(String string, boolean bl) throws ParserConfigurationException {
        if (this.features == null) {
            this.features = new Hashtable();
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            if (System.getSecurityManager() != null && !bl) {
                throw new ParserConfigurationException(SAXMessageFormatter.formatMessage(null, "jaxp-secureprocessing-feature", null));
            }
            this.fSecureProcess = bl;
            this.features.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
            return;
        }
        this.features.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        try {
            new DocumentBuilderImpl(this, this.attributes, this.features);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            this.features.remove(string);
            throw new ParserConfigurationException(sAXNotSupportedException.getMessage());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            this.features.remove(string);
            throw new ParserConfigurationException(sAXNotRecognizedException.getMessage());
        }
    }
}

