/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ClassArrayEditor
extends PropertyEditorSupport {
    private final ClassLoader classLoader;

    public ClassArrayEditor() {
        this(null);
    }

    public ClassArrayEditor(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (StringUtils.hasText((String)string)) {
            String[] stringArray = StringUtils.commaDelimitedListToStringArray((String)string);
            Class[] classArray = new Class[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                classArray[i] = ClassUtils.resolveClassName((String)string2, (ClassLoader)this.classLoader);
            }
            this.setValue(classArray);
        } else {
            this.setValue(null);
        }
    }

    public String getAsText() {
        Class[] classArray = (Class[])this.getValue();
        if (classArray == null || classArray.length == 0) {
            return "";
        }
        return ClassArrayEditor.toCommaDelimitedString(classArray);
    }

    private static String toCommaDelimitedString(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(ClassUtils.getQualifiedName((Class)classArray[i]));
        }
        return stringBuffer.toString();
    }
}

