/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.communicate;

import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.communicate.ModbusHandlerMaster;
import cn.com.voltronic.solar.modbusprocessor.ModbusAddress;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import net.wimpi.modbus.ModbusException;
import net.wimpi.modbus.facade.ModbusSerialMaster;
import net.wimpi.modbus.procimg.InputRegister;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.util.BitVector;
import org.apache.log4j.Logger;

public class ModbusHandler
implements ICommunicateDevice {
    private static Logger logger = Logger.getLogger(ModbusHandler.class);
    private ModbusHandlerMaster _master;
    private ModbusSerialMaster _modbus;
    private int _machineID;
    private boolean _active;
    private int _errorcount = 0;
    private boolean mustClose = false;
    public int delaycount = 0;
    public int successcount = 0;
    private AbstractProcessor notifyProcesser;

    public void setMustClose() {
        logger.error((Object)"setMustClose close");
        this.mustClose = true;
        if (this.notifyProcesser != null) {
            this.notifyProcesser.close();
        }
    }

    public boolean isMustClose() {
        return this.mustClose;
    }

    private void countErrorandNotifyProcesser(int count, boolean success) {
        if (success) {
            this._errorcount = 0;
            this._master.resetError();
        } else {
            ++this._errorcount;
        }
        if (success) {
            ++this.successcount;
            if (this._modbus.getCurrentTryTimes() > 0) {
                ++this.delaycount;
                int shortdelay = this._master.getShort_delay();
                if (shortdelay < this._master.getNormal_delay()) {
                    this._master.setShort_delay(shortdelay + 5);
                    this.successcount = 0;
                    this.delaycount = 0;
                } else if (this.successcount >= 20 && this.delaycount * 20 > this.successcount || this.successcount < 20 && this.delaycount > 1) {
                    if (shortdelay < this._master.getLong_delay()) {
                        this._master.setShort_delay(shortdelay + 5);
                    }
                    this.successcount = 0;
                    this.delaycount = 0;
                }
            }
        }
        if (this._errorcount >= 5 && this.notifyProcesser != null) {
            logger.error((Object)("notify process remove" + this.notifyProcesser.processorKey()));
            this.notifyProcesser.close();
        }
    }

    public ModbusHandler(ModbusHandlerMaster master, ModbusSerialMaster modbus, int machineID) {
        this._master = master;
        this._modbus = modbus;
        this._machineID = machineID;
        this._active = false;
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public int getMachineID() {
        return this._machineID;
    }

    public ModbusHandlerMaster getMaster() {
        return this._master;
    }

    public BitVector readCoils(int ref, int count) throws Exception {
        BitVector result = null;
        this._master.lock();
        try {
            if (this._modbus != null) {
                result = this._modbus.readCoils(this._machineID, ref, count);
            }
        }
        catch (Throwable throwable) {
            this.countErrorandNotifyProcesser(count, result != null);
            this._master.unlock();
            throw throwable;
        }
        this.countErrorandNotifyProcesser(count, result != null);
        this._master.unlock();
        return result;
    }

    public boolean writeCoil(int ref, boolean state) throws Exception {
        this._master.lock();
        boolean result = false;
        try {
            if (this._modbus != null) {
                result = this._modbus.writeCoil(this._machineID, ref, state);
            }
        }
        finally {
            this.countErrorandNotifyProcesser(1, result);
            this._master.unlock();
        }
        return result;
    }

    public void writeMultipleCoils(int ref, BitVector coils) throws Exception {
        this._master.lock();
        boolean result = false;
        try {
            if (this._modbus != null) {
                this._modbus.writeMultipleCoils(this._machineID, ref, coils);
                result = true;
            }
        }
        finally {
            this.countErrorandNotifyProcesser(1, result);
            this._master.unlock();
        }
    }

    public BitVector readInputDiscretes(int ref, int count) throws Exception {
        this._master.lock();
        BitVector result = null;
        try {
            if (this._modbus != null) {
                result = this._modbus.readInputDiscretes(this._machineID, ref, count);
            }
        }
        catch (Throwable throwable) {
            this.countErrorandNotifyProcesser(1, result != null);
            this._master.unlock();
            throw throwable;
        }
        this.countErrorandNotifyProcesser(1, result != null);
        this._master.unlock();
        return result;
    }

    public InputRegister[] readInputRegisters(int ref, int count) throws Exception {
        this._master.lock();
        InputRegister[] result = null;
        try {
            if (this._modbus != null) {
                result = this._modbus.readInputRegisters(this._machineID, ref, count);
            }
        }
        catch (Throwable throwable) {
            this.countErrorandNotifyProcesser(1, result != null);
            this._master.unlock();
            throw throwable;
        }
        this.countErrorandNotifyProcesser(1, result != null);
        this._master.unlock();
        return result;
    }

    public Register[] readMultipleRegisters(int ref, int count) throws Exception {
        this._master.lock();
        Register[] result = null;
        try {
            if (this._modbus != null) {
                this._modbus.setTransDelayMS(800);
                result = this._modbus.readMultipleRegisters(this._machineID, ref, count);
            }
        }
        catch (Throwable throwable) {
            this.countErrorandNotifyProcesser(count, result != null);
            this._master.unlock();
            throw throwable;
        }
        this.countErrorandNotifyProcesser(count, result != null);
        this._master.unlock();
        return result;
    }

    public void writeSingleRegister(int ref, Register register) throws Exception {
        this._master.lock();
        boolean result = false;
        try {
            if (this._modbus != null) {
                this._modbus.writeSingleRegister(this._machineID, ref, register);
                result = true;
            }
        }
        finally {
            this.countErrorandNotifyProcesser(1, result);
            this._master.unlock();
        }
    }

    public void writeMultipleRegisters(int ref, Register[] registers) throws Exception {
        this._master.lock();
        boolean result = false;
        try {
            try {
                if (this._modbus != null) {
                    this._modbus.setTransDelayMS(500);
                    this._modbus.writeMultipleRegisters(this._machineID, ref, registers);
                    result = true;
                }
            }
            catch (ModbusException e) {
                this._master.processError(this._active, e.getMessage());
                throw e;
            }
        }
        finally {
            this.countErrorandNotifyProcesser(registers.length, result);
            this._master.unlock();
        }
    }

    @Override
    public String getDeviceName() {
        return String.valueOf(this._master.getDeviceName()) + "[" + this._machineID + "]";
    }

    @Override
    public void close() {
        this.setActive(false);
        this._master.close(this._machineID);
    }

    @Override
    public void setNotifyProcess(AbstractProcessor process) {
        this.notifyProcesser = process;
    }

    public String getSerialNo() {
        String buffer = "";
        int i = 0;
        while (i < 3) {
            try {
                Register[] qid = this.readMultipleRegisters(ModbusAddress.serial_number, 8);
                int item = 0;
                while (item < qid.length) {
                    buffer = String.valueOf(buffer) + new String(qid[item].toBytes()).trim();
                    ++item;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!buffer.isEmpty()) break;
            buffer = "";
            ++i;
        }
        return buffer;
    }

    public String getMachineType() {
        String machineType = "";
        int i = 0;
        while (i < 3) {
            try {
                Register[] regs = this.readMultipleRegisters(84, 1);
                machineType = String.valueOf(regs[0].getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!machineType.isEmpty()) break;
            machineType = "";
            ++i;
        }
        return machineType;
    }
}

