/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.dao;

import cn.com.voltronic.solar.dao.BaseDao;
import cn.com.voltronic.solar.data.bean.DataBeforeFault;
import cn.com.voltronic.solar.dbtools.DBManager;
import cn.com.voltronic.solar.util.DateUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class FaultDataDao
extends BaseDao {
    private final String DELETE_FAULTDATA = "delete from faultdata where serialno = ? and trandate between ? and ?";
    private final String DELETE_FAULTDATA_ALL = "delete from faultdata where serialno = ? and trandate BETWEEN ? and ?";

    public List<String> getAllProdid() {
        ArrayList<String> result;
        block6: {
            result = new ArrayList<String>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT distinct prodid FROM faultdata");
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result.add(rs.getString("prodid"));
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public String getProdidBySerialno(String serialno) {
        String result;
        block6: {
            result = "";
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT distinct prodid FROM faultdata where serialno=?");
                    ps.setString(1, serialno);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result = rs.getString("prodid");
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public List<String> getSerialNo() {
        ArrayList<String> result;
        block6: {
            result = new ArrayList<String>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT distinct serialno FROM faultdata order by serialno");
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result.add(rs.getString("serialno"));
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public boolean alreadyInsert(DataBeforeFault data) {
        boolean result;
        block6: {
            result = false;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select * from faultdata where serialno=? and trandate=? and faultString=? order by trandate desc");
                    ps.setString(1, data.getSerialno());
                    ps.setTimestamp(2, new Timestamp(data.getTrandate().getTime()));
                    ps.setString(3, data.getFaultString());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result = true;
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public boolean insertData(DataBeforeFault faultdata) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(" INSERT INTO faultdata ( prodid,serialno,faultString,trandate,workmode,gridvoltager,gridfrequency,pvinputvoltage1,outputapparentpower,outputactivepower,pbatteryvoltage,batterycapacity,chargingcurrent,acoutputvoltager,acoutputfrequency,ttlchargingcurrent,ttloutputapparentpower,ttloutputactivepower,ttloutputpercent,pvInputCurrent,batDisCurrent,pvinputvoltage2,pvinputvoltage3) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                ps.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public List<DataBeforeFault> queryData(String serialno, Date beginDate, Date endDate) {
        ArrayList<DataBeforeFault> resultList;
        block6: {
            String prodid = "P42";
            prodid = this.getProdidBySerialno(serialno);
            Calendar end = Calendar.getInstance();
            end.setTime(endDate);
            Calendar start = Calendar.getInstance();
            start.setTime(beginDate);
            resultList = new ArrayList<DataBeforeFault>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select * from faultdata where serialno=? and trandate between ? and ? order by trandate desc");
                    ps.setString(1, serialno);
                    ps.setTimestamp(2, new Timestamp(DateUtils.getStartofDayFullTime(start).getTime().getTime()));
                    ps.setTimestamp(3, new Timestamp(DateUtils.getEndofDayFullTime(end).getTime().getTime()));
                    rs = ps.executeQuery();
                    conn.commit();
                    while (rs.next()) {
                        DataBeforeFault data = new DataBeforeFault();
                        data.setSerialno(serialno);
                        data.setTrandate(rs.getTimestamp("trandate"));
                        String faultString = "";
                        data.setFaultString(faultString);
                        resultList.add(data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return resultList;
    }

    public boolean removeData(String serialno, Date date) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("delete from faultdata where serialno = ? and trandate between ? and ?");
                ps.setString(1, serialno);
                ps.setTimestamp(2, new Timestamp(date.getTime()));
                Calendar ca = Calendar.getInstance();
                ca.setTime(date);
                ca.add(13, 1);
                ps.setTimestamp(3, new Timestamp(ca.getTime().getTime()));
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean removeDataAll(String serialno, Date fromDate, Date toDate) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("delete from faultdata where serialno = ? and trandate BETWEEN ? and ?");
                ps.setString(1, serialno);
                ps.setDate(2, new java.sql.Date(fromDate.getTime()));
                ps.setDate(3, new java.sql.Date(toDate.getTime() + 86400000L));
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean removeAll() {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("delete from faultdata");
                ps.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public static void main(String[] args) {
        FaultDataDao dao = new FaultDataDao();
        DataBeforeFault faultdata = new DataBeforeFault();
        faultdata.setProdid("P16");
        faultdata.setSerialno("90000000000002");
        faultdata.setFaultString("1002");
        boolean re = dao.insertData(faultdata);
        System.out.println(re);
    }
}

