/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.dao;

import cn.com.voltronic.solar.dao.BaseDao;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.dbtools.DBManager;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class WorkDataDao
extends BaseDao {
    @Override
    public boolean writeRecords() {
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        if (workinfo.getProdid() == null || "".equals(workinfo.getProdid()) || workinfo.getSerialNo() == null || "".equals(workinfo.getSerialNo()) || workinfo.getCurrentTime() == null || workinfo.getWorkMode() == null || "---".equals(workinfo.getWorkMode()) || "".equals(workinfo.getWorkMode())) {
            return false;
        }
        return this.insertWorkInfo(workinfo);
    }

    public boolean removeWork(String prodid, String serialno, Date date) {
        boolean result;
        block6: {
            result = false;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            try {
                try {
                    String sqlStr = "delete from WORK_DATA where prodid=? and serialno=? and currentTime between ? and ?";
                    ps = conn.prepareStatement(sqlStr);
                    ps.setString(1, prodid);
                    ps.setString(2, serialno);
                    ps.setTimestamp(3, new Timestamp(date.getTime()));
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    cal.add(13, 1);
                    ps.setTimestamp(4, new Timestamp(cal.getTime().getTime()));
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(ps);
                throw throwable;
            }
            this.close(ps);
        }
        return result;
    }

    public boolean removeAllWork(String prodid, String serialno, Date beginDate, Date endDate) {
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        Calendar start = Calendar.getInstance();
        start.setTime(beginDate);
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("delete from WORK_DATA where prodid=? and serialno=? and currentTime between ? and ?");
                ps.setString(1, prodid);
                ps.setString(2, serialno);
                ps.setTimestamp(3, new Timestamp(DateUtils.getStartofDayFullTime(start).getTime().getTime()));
                ps.setTimestamp(4, new Timestamp(DateUtils.getEndofDayFullTime(end).getTime().getTime()));
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean insertWorkInfo(WorkInfo workinfo) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(" INSERT INTO WORK_DATA (    prodid,serialNo,workMode,currentTime,tempMachine,tempEnvironment,inputVoltagePV,inputVoltageBUS,outputVoltageUV,outputVoltageVW,   outputFrequency,outputCurrentU,outputCurrentV,outputCurrentW,outputVoltageAdjustValueUV,outputVoltageAdjustValueVW,outputCurrentAdjustValueU,   outputCurrentAdjustValueV,outputCurrentAdjustValueW,outputPowerU,outputPowerV,outputPowerW,outputPowerTotal,DC2Voltage) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                ps.setString(1, workinfo.getProdid());
                ps.setString(2, workinfo.getSerialNo());
                ps.setString(3, workinfo.getWorkMode());
                ps.setTimestamp(4, new Timestamp(workinfo.getCurrentTime().getTime()));
                ps.setDouble(5, workinfo.getTempMachine());
                ps.setDouble(6, workinfo.getTempEnvironment());
                ps.setDouble(7, workinfo.getInputVoltagePV());
                ps.setDouble(8, workinfo.getInputVoltageBUS());
                ps.setDouble(9, workinfo.getOutputVoltageUV());
                ps.setDouble(10, workinfo.getOutputVoltageVW());
                ps.setDouble(11, workinfo.getOutputFrequency());
                ps.setDouble(12, workinfo.getOutputCurrentU());
                ps.setDouble(13, workinfo.getOutputCurrentV());
                ps.setDouble(14, workinfo.getOutputCurrentW());
                ps.setDouble(15, workinfo.getOutputVoltageAdjustValueUV());
                ps.setDouble(16, workinfo.getOutputVoltageAdjustValueVW());
                ps.setDouble(17, workinfo.getOutputCurrentAdjustValueU());
                ps.setDouble(18, workinfo.getOutputCurrentAdjustValueV());
                ps.setDouble(19, workinfo.getOutputCurrentAdjustValueW());
                ps.setInt(20, workinfo.getOutputPowerU());
                ps.setInt(21, workinfo.getOutputPowerV());
                ps.setInt(22, workinfo.getOutputPowerW());
                ps.setInt(23, workinfo.getOutputPowerTotal());
                ps.setDouble(24, workinfo.getDC2Voltage());
                if (workinfo.getCurrentTime() != null && ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public List<WorkInfo> queryWorkInfo(String prodid, String serialno, Date beginDate, Date endDate) {
        ArrayList<WorkInfo> result;
        block6: {
            Calendar end = Calendar.getInstance();
            end.setTime(endDate);
            Calendar start = Calendar.getInstance();
            start.setTime(beginDate);
            result = new ArrayList<WorkInfo>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select * from WORK_DATA where prodid=? and serialno=? and currenttime between ? and ? order by currenttime desc");
                    ps.setString(1, prodid);
                    ps.setString(2, serialno);
                    ps.setTimestamp(3, new Timestamp(DateUtils.getStartofDayFullTime(start).getTime().getTime()));
                    ps.setTimestamp(4, new Timestamp(DateUtils.getEndofDayFullTime(end).getTime().getTime()));
                    rs = ps.executeQuery();
                    conn.commit();
                    while (rs.next()) {
                        WorkInfo data = new WorkInfo();
                        data = this.getWorkInDB(data, rs);
                        result.add(data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    private Calendar[] getMinMaxDate(String prodid, String serialno, int year, Date begin, Date end) {
        Calendar[] result;
        block7: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            result = new Calendar[2];
            if (conn != null) {
                try {
                    try {
                        ps = conn.prepareStatement(" select min(currenttime) mindate, max(currenttime) maxdate from WORK_DATA where prodid=? and serialno=? and currenttime>= ? and currenttime< ? ");
                        ps.setString(1, prodid);
                        ps.setString(2, serialno);
                        ps.setDate(3, new java.sql.Date(begin.getTime()));
                        ps.setDate(4, new java.sql.Date(end.getTime()));
                        rs = ps.executeQuery();
                        if (rs != null && rs.next() && rs.getTimestamp("mindate") != null && rs.getTimestamp("maxdate") != null) {
                            result[0] = Calendar.getInstance();
                            result[0].setTime(rs.getTimestamp("mindate"));
                            result[1] = Calendar.getInstance();
                            result[1].setTime(rs.getTimestamp("maxdate"));
                        }
                    }
                    catch (Exception exception) {
                        this.close(rs, ps);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs, ps);
                    throw throwable;
                }
                this.close(rs, ps);
            }
        }
        return result;
    }

    private String workInfofieldList() {
        String field = " max(prodid) as prodid, max(serialNo) serialNo, max(currentTime) as currentTime, max(workMode) as workMode, max(tempMachine) as tempMachine, max(tempEnvironment) as tempEnvironment, max(inputVoltagePV) as inputVoltagePV , max(inputVoltageBUS) as inputVoltageBUS, max(outputVoltageUV) as outputVoltageUV, max(outputVoltageVW) as outputVoltageVW, max(outputFrequency) as outputFrequency, max(outputCurrentU) as outputCurrentU, max(outputCurrentV) as outputCurrentV, max(outputCurrentW) as outputCurrentW, max(outputVoltageAdjustValueUV) as outputVoltageAdjustValueUV, max(outputVoltageAdjustValueVW) as outputVoltageAdjustValueVW, max(outputCurrentAdjustValueU) as outputCurrentAdjustValueU, max(outputCurrentAdjustValueV) as outputCurrentAdjustValueV, max(outputCurrentAdjustValueW) as outputCurrentAdjustValueW, max(outputPowerU) as outputPowerU, max(outputPowerV) as outputPowerV, max(outputPowerW) as outputPowerW, max(outputPowerTotal) as outputPowerTotal, max(DC2Voltage) as DC2Voltage";
        return field;
    }

    private WorkInfo getWorkData(String prodid, String serialno, int year, Calendar mindbDate, Calendar maxdbDate, Calendar begin, Calendar enddate) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        WorkInfo work = new WorkInfo();
        try {
            try {
                if (mindbDate != null && maxdbDate != null && begin.compareTo(maxdbDate) <= 0 && enddate.compareTo(mindbDate) >= 0) {
                    ps = conn.prepareStatement(" select " + this.workInfofieldList() + " from WORK_DATA where prodid= ? and  SERIALNO = ? and currenttime>= ? and currenttime<? order by currenttime ");
                    Timestamp timeb = new Timestamp(begin.getTime().getTime());
                    Timestamp timee = new Timestamp(enddate.getTime().getTime());
                    ps.setString(1, prodid);
                    ps.setString(2, serialno);
                    ps.setTimestamp(3, timeb);
                    ps.setTimestamp(4, timee);
                    rs = ps.executeQuery();
                    if (rs != null && rs.next()) {
                        work = this.getWorkInDB(work, rs);
                    }
                }
                work.setCurrentTime(begin.getTime());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(rs, ps);
            }
        }
        finally {
            this.close(rs, ps);
        }
        return work;
    }

    public List<WorkInfo> getWorkDatasByYear(int year, String prodid, String serialno) {
        Calendar ca = Calendar.getInstance();
        ca.set(year, 0, 1, 0, 0, 0);
        Calendar endtime = Calendar.getInstance();
        endtime.set(year + 1, 0, 1, 0, 0, 0);
        Calendar tempDate = (Calendar)ca.clone();
        ArrayList<WorkInfo> works = new ArrayList<WorkInfo>();
        try {
            Calendar[] minmaxdate = this.getMinMaxDate(prodid, serialno, year, ca.getTime(), endtime.getTime());
            while (ca.before(endtime)) {
                tempDate.add(5, 3);
                if (tempDate.after(endtime)) {
                    tempDate = endtime;
                }
                works.add(this.getWorkData(prodid, serialno, year, minmaxdate[0], minmaxdate[1], ca, tempDate));
                ca.add(6, 3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return works;
    }

    public List<WorkInfo> getWorkDatasByMonth(int year, int month, String prodid, String serialno) {
        Calendar ca = Calendar.getInstance();
        ca.set(year, month - 1, 1, 0, 0, 0);
        Calendar endtime = Calendar.getInstance();
        endtime.set(year, month, 1, 0, 0, 0);
        Calendar tempDate = (Calendar)ca.clone();
        ArrayList<WorkInfo> works = new ArrayList<WorkInfo>();
        try {
            Calendar[] minmaxdate = this.getMinMaxDate(prodid, serialno, year, ca.getTime(), endtime.getTime());
            while (ca.before(endtime)) {
                tempDate.add(11, 6);
                if (tempDate.after(endtime)) {
                    tempDate = endtime;
                }
                works.add(this.getWorkData(prodid, serialno, year, minmaxdate[0], minmaxdate[1], ca, tempDate));
                ca.add(11, 6);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return works;
    }

    public List<WorkInfo> getWorkDatasByDay(Date queryDate, String prodid, String serialno) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(queryDate);
        ca = DateUtils.getShortdate(ca);
        Calendar endtime = (Calendar)ca.clone();
        endtime.add(5, 1);
        Calendar tempDate = (Calendar)ca.clone();
        ArrayList<WorkInfo> works = new ArrayList<WorkInfo>();
        int year = ca.get(1);
        try {
            Calendar[] minmaxdate = this.getMinMaxDate(prodid, serialno, year, ca.getTime(), endtime.getTime());
            while (ca.before(endtime)) {
                tempDate.add(12, 15);
                if (tempDate.after(endtime)) {
                    tempDate = endtime;
                }
                works.add(this.getWorkData(prodid, serialno, year, minmaxdate[0], minmaxdate[1], ca, tempDate));
                ca.add(12, 15);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return works;
    }

    public List<WorkInfo> getWorkDatasByHour(Date queryDate, int hour, String prodid, String serialno) {
        ArrayList<WorkInfo> works;
        block10: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            Calendar ca = Calendar.getInstance();
            ca.setTime(queryDate);
            ca = DateUtils.getShortdate(ca);
            ca.set(11, hour);
            Calendar endtime = (Calendar)ca.clone();
            endtime.add(11, 1);
            works = new ArrayList<WorkInfo>();
            try {
                try {
                    ps = conn.prepareStatement(" select * from WORK_DATA where prodid=? and serialno=? and currenttime>=? and currenttime<? order by currenttime ", 1004, 1007);
                    ps.setString(1, prodid);
                    ps.setString(2, serialno);
                    ps.setTimestamp(3, new Timestamp(ca.getTime().getTime()));
                    ps.setTimestamp(4, new Timestamp(endtime.getTime().getTime()));
                    rs = ps.executeQuery();
                    Long temp = null;
                    int target = 60;
                    while (rs.next()) {
                        int temptarget;
                        Long time = rs.getTimestamp("currentTime").getTime();
                        if (temp != null && (temptarget = (int)(time - temp) / 1000) < target && temptarget % 30 == 0 && temptarget > 0) {
                            target = temptarget;
                        }
                        temp = time;
                    }
                    rs.beforeFirst();
                    while (rs.next()) {
                        Timestamp recordTime = rs.getTimestamp("currentTime");
                        long recordMillis = ((Date)recordTime).getTime();
                        if (recordMillis < ca.getTimeInMillis()) continue;
                        WorkInfo workinfo = new WorkInfo();
                        while (recordMillis > ca.getTimeInMillis() + 60000L) {
                            workinfo.setCurrentTime(ca.getTime());
                            works.add(workinfo);
                            ca.add(13, target);
                        }
                        WorkInfo work = new WorkInfo();
                        work = this.getWorkInDB(work, rs);
                        works.add(work);
                        ca.add(13, target);
                    }
                    while (ca.get(11) == hour) {
                        WorkInfo work = new WorkInfo();
                        work.setCurrentTime(ca.getTime());
                        works.add(work);
                        ca.add(13, target);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return works;
    }

    private WorkInfo getWorkInDB(WorkInfo work, ResultSet rs) throws Exception {
        WorkInfo data = work;
        data.setProdid(rs.getString("prodid"));
        data.setSerialNo(rs.getString("serialNo"));
        data.setWorkMode(rs.getString("workMode"));
        data.setCurrentTime(rs.getTimestamp("currentTime"));
        data.setTempMachine(rs.getInt("tempMachine"));
        data.setTempEnvironment(rs.getInt("tempEnvironment"));
        data.setInputVoltagePV(rs.getDouble("inputVoltagePV"));
        data.setInputVoltageBUS(rs.getDouble("inputVoltageBUS"));
        data.setOutputVoltageUV(rs.getDouble("outputVoltageUV"));
        data.setOutputVoltageVW(rs.getDouble("outputVoltageVW"));
        data.setOutputFrequency(rs.getDouble("outputFrequency"));
        data.setOutputCurrentU(rs.getDouble("outputCurrentU"));
        data.setOutputCurrentV(rs.getDouble("outputCurrentV"));
        data.setOutputCurrentW(rs.getDouble("outputCurrentW"));
        data.setOutputVoltageAdjustValueUV(rs.getDouble("outputVoltageAdjustValueUV"));
        data.setOutputVoltageAdjustValueVW(rs.getDouble("outputVoltageAdjustValueVW"));
        data.setOutputCurrentAdjustValueU(rs.getDouble("outputCurrentAdjustValueU"));
        data.setOutputCurrentAdjustValueV(rs.getDouble("outputCurrentAdjustValueV"));
        data.setOutputCurrentAdjustValueW(rs.getDouble("outputCurrentAdjustValueW"));
        data.setOutputPowerU(rs.getInt("outputPowerU"));
        data.setOutputPowerV(rs.getInt("outputPowerV"));
        data.setOutputPowerW(rs.getInt("outputPowerW"));
        data.setOutputPowerTotal(rs.getInt("outputPowerTotal"));
        data.setDC2Voltage(rs.getDouble("DC2Voltage"));
        VolUtil.setTempMachine(data);
        VolUtil.setTempEnvironment(data);
        return work;
    }
}

