/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.modbusprocessor;

import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import java.util.HashMap;
import java.util.Map;
import net.wimpi.modbus.procimg.Register;

public abstract class AbstractModbusProcessor
extends AbstractProcessor {
    public static final double DOUBLE_TEN = 10.0;
    public static final double DOUBLE_HUNDRED = 100.0;
    public static Map<Integer, String> faultMap = new HashMap<Integer, String>();

    public AbstractModbusProcessor(ModbusHandler handler, IProtocol protocol) {
        super(handler, protocol);
        protocol.setRelationList();
        this.initFaultMap();
    }

    @Override
    public ModbusHandler getHandler() {
        return (ModbusHandler)super.getHandler();
    }

    public static long convert3Regiters(Register sign, Register first, Register second) {
        int factor = 1;
        if (sign.getValue() > 0) {
            factor = -1;
        }
        long high = first.getValue();
        long result = high << 16;
        return (long)factor * (result += (long)second.getValue());
    }

    public static long convert2Regiters(Register first, Register second) {
        int factor = 1;
        long high = first.getValue();
        long result = high << 16;
        return (long)factor * (result += (long)second.getValue());
    }

    public void processEvent(boolean isWarning, String eventId, WorkInfo workinfo) {
        if (isWarning) {
            if (!workinfo.getWarnings().contains(eventId)) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialNo(), workinfo.getCurrentTime(), eventId);
                workinfo.addWarning(eventId);
            }
        } else if (workinfo.getWarnings().contains(eventId)) {
            workinfo.getWarnings().remove(eventId);
        }
    }

    private void initFaultMap() {
        faultMap.put(1, "1001");
        faultMap.put(2, "1002");
        faultMap.put(3, "1003");
        faultMap.put(4, "1004");
        faultMap.put(5, "1005");
        faultMap.put(6, "1006");
        faultMap.put(7, "1007");
        if (!this.getHandler().getMachineType().equals("11")) {
            faultMap.put(8, "1008");
        }
        faultMap.put(9, "1009");
        faultMap.put(10, "1010");
        faultMap.put(11, "1011");
        faultMap.put(12, "1012");
        faultMap.put(13, "1013");
        faultMap.put(14, "1014");
        faultMap.put(15, "1015");
        if (this.getHandler().getMachineType().equals("11")) {
            faultMap.put(16, "1016");
            faultMap.put(17, "1017");
            faultMap.put(18, "1018");
        }
    }
}

