/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.test;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;

public class TestComm {
    private InputStream input = null;
    private static String RETURN_ANY = "ANY";
    private OutputStream output = null;
    private SerialPort serialPort;

    private void clearbuffer() {
        try {
            int buflen = this.input.available();
            while (buflen > 0) {
                int x = this.input.read();
                --buflen;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TestComm(SerialPort serialPort) throws IOException, TooManyListenersException, UnsupportedCommOperationException {
        this.serialPort = serialPort;
        this.input = serialPort.getInputStream();
        this.output = serialPort.getOutputStream();
        this.serialPort.setSerialPortParams(2400, 8, 1, 0);
        this.serialPort.notifyOnDataAvailable(true);
        this.serialPort.notifyOnCTS(true);
        this.serialPort.notifyOnDSR(true);
    }

    private boolean executeComboxCommand(String command, String value, int timeout) throws IOException {
        boolean match = false;
        String firstvalue = null;
        while (!match) {
            String result = this.executeOnecommand(command.getBytes(), timeout);
            if (result.equalsIgnoreCase(value)) {
                match = true;
                break;
            }
            if (firstvalue == null) {
                firstvalue = result;
            } else if (firstvalue.equalsIgnoreCase(result)) {
                return false;
            }
            result = this.executeOnecommand(new byte[]{45}, timeout);
        }
        return true;
    }

    public synchronized String executeSinglSetValue(String command, String value, int timeout) throws IOException {
        this.executeOnecommand(command.getBytes(), 50);
        String cmd = "-" + value;
        return this.executeOnecommand(cmd.getBytes(), timeout);
    }

    private boolean executeCommand9FFE() {
        boolean success = false;
        try {
            success = "OK".equals(this.executeOnecommand(new byte[]{-97, -2}, 50));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return success;
    }

    private boolean executeCommand9FFF() {
        boolean success = false;
        try {
            success = "OK".equals(this.executeOnecommand(new byte[]{-97, -2}, 50));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return success;
    }

    private boolean executeNumber(String value) {
        boolean success = true;
        byte[][] table = new byte[][]{{-97, -64}, {-97, -63}, {-97, -62}, {-97, -61}, {-97, -60}, {-97, -59}, {-97, -58}, {-97, -57}, {-97, -56}, {-97, -55}};
        value = value.trim();
        int index = 0;
        while (index < value.length()) {
            block8: {
                char curchar = value.charAt(index);
                try {
                    if (curchar == '.') {
                        if (!("OK".equals(this.executeOnecommand(new byte[]{-97, -49}, 50)) && "OK".equals(this.executeOnecommand(new byte[]{-97, -50}, 50)) && ":.".equals(this.executeOnecommand(new byte[]{-97, -58}, 50)))) {
                            success = false;
                        }
                    } else {
                        int pos = Integer.parseInt("" + curchar);
                        if (pos < 0 && pos > 9) {
                            success = false;
                            break;
                        }
                        if (!(":" + curchar).equals(this.executeOnecommand(table[pos], 50))) {
                            success = false;
                        }
                    }
                    break block8;
                }
                catch (Exception e) {
                    success = false;
                }
                break;
            }
            ++index;
        }
        return success;
    }

    public synchronized boolean executeDoubleSetValue(byte[][] cmdbuff, String value, String[] checkuff, int timeout) throws IOException {
        boolean bsuccess = true;
        int line_i = 0;
        if (this.executeCommand9FFE()) {
            if (this.executeNumber(value)) {
                line_i = 0;
                while (line_i < cmdbuff.length) {
                    String result = this.executeOnecommand(cmdbuff[line_i], timeout);
                    if (checkuff[line_i].equals(RETURN_ANY)) {
                        if (result.length() == 0) {
                            bsuccess = false;
                            break;
                        }
                    } else if (!result.equalsIgnoreCase(checkuff[line_i])) {
                        bsuccess = false;
                        break;
                    }
                    ++line_i;
                }
            }
            this.executeCommand9FFF();
        }
        return bsuccess;
    }

    public synchronized boolean executeDoubleED(byte[][] sendbuff, String[] checkbuff, int timeout) throws IOException {
        boolean bsuccess = true;
        int line_i = 0;
        if (this.executeCommand9FFE()) {
            line_i = 0;
            while (line_i < sendbuff.length) {
                String result = this.executeOnecommand(sendbuff[line_i], timeout);
                if (checkbuff[line_i].equals(RETURN_ANY)) {
                    if (result.length() == 0) {
                        bsuccess = false;
                        break;
                    }
                } else if (!result.equalsIgnoreCase(checkbuff[line_i])) {
                    bsuccess = false;
                    break;
                }
                ++line_i;
            }
            this.executeCommand9FFF();
        }
        return bsuccess;
    }

    public String executeOnecommand(byte[] bytes, int timeout) throws IOException {
        int index = 0;
        boolean firstcmd = true;
        this.clearbuffer();
        index = 0;
        while (index < bytes.length) {
            this.output.write(bytes[index]);
            this.output.flush();
            try {
                Thread.sleep(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++index;
        }
        long end = System.currentTimeMillis() + 3000L;
        StringBuilder sb = new StringBuilder();
        int flag = 0;
        while (System.currentTimeMillis() < end) {
            int ch = this.input.read();
            if (ch < 0) continue;
            System.out.println(" " + ch + "=" + (char)ch);
            if (firstcmd && (ch == 33 || ch == 36 || ch == 37 || ch == 43 || ch == 63 || ch == 61 || ch == 42 || ch == 35 || ch == 38 || ch == 124)) continue;
            if (ch == 13) {
                flag = 1;
                continue;
            }
            if (ch == 10 && flag == 1) {
                flag = 2;
                break;
            }
            firstcmd = false;
            sb.append((char)ch);
        }
        if (flag != 2) {
            throw new IOException();
        }
        String returnValue = sb.toString();
        return returnValue;
    }

    public synchronized String excuteCommand(String command, boolean isResponse) {
        String returnValue;
        block7: {
            returnValue = "";
            try {
                try {
                    byte[] bytes = command.getBytes();
                    this.output.write(bytes);
                    this.output.write(13);
                    this.output.flush();
                    if (isResponse) {
                        long end = System.currentTimeMillis() + 3000L;
                        StringBuilder sb = new StringBuilder();
                        while (System.currentTimeMillis() < end) {
                            int ch = this.input.read();
                            if (ch <= 0) continue;
                            if (ch == 13) break;
                            sb.append((char)ch);
                        }
                        returnValue = sb.toString();
                        break block7;
                    }
                    returnValue = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.close();
                }
            }
            finally {
                this.close();
            }
        }
        return returnValue;
    }

    public void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.serialPort != null) {
            try {
                this.serialPort.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        Enumeration en = CommPortIdentifier.getPortIdentifiers();
        while (en.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)en.nextElement();
            if (portId.getPortType() != 1 || !portId.getName().equalsIgnoreCase("COM8")) continue;
            System.out.println(portId.getName());
            try {
                SerialPort serialPort = (SerialPort)portId.open("Arista", 2400);
                TestComm comm = new TestComm(serialPort);
                System.out.println(comm.executeOnecommand(new byte[]{89}, 10));
                System.out.println(comm.executeOnecommand(new byte[]{26}, 50));
                System.out.println(comm.executeSinglSetValue("x", "09/07/13", 50));
                System.out.println(comm.executeOnecommand(new byte[]{120}, 50));
                System.out.println(comm.executeOnecommand(new byte[]{57}, 50));
                System.out.println(comm.executeComboxCommand("p", "180", 50));
                System.out.println(comm.executeOnecommand(new byte[]{-97, -46}, 50));
                System.out.println(comm.executeOnecommand(new byte[]{-97, -47}, 50));
                System.out.println(comm.executeOnecommand(new byte[]{-97, -41}, 50));
                System.out.println(comm.executeOnecommand(new byte[]{-97, -42}, 50));
                System.out.println("E2=" + comm.executeOnecommand(new byte[]{-97, -30}, 50));
                System.out.println("E3=" + comm.executeOnecommand(new byte[]{-97, -29}, 50));
                System.out.println(comm.executeDoubleED(new byte[][]{{-97, -30}, {-97, -53}}, new String[]{RETURN_ANY, "OK"}, 50));
                System.out.println(comm.executeDoubleED(new byte[][]{{-97, -29}, {-97, -54}}, new String[]{RETURN_ANY, "OK"}, 50));
                System.out.println(comm.executeDoubleED(new byte[][]{{-97, -32}}, new String[]{"OK"}, 50));
                System.out.println(comm.executeDoubleSetValue(new byte[][]{{-97, -16}, {-97, -54}}, "52.0", new String[]{RETURN_ANY, "OK"}, 50));
                System.out.println(comm.executeDoubleSetValue(new byte[][]{{-97, -15}, {-97, -54}}, "250", new String[]{RETURN_ANY, "OK"}, 50));
                System.out.println(comm.executeDoubleSetValue(new byte[][]{{-97, -31}}, "01", new String[]{"OK"}, 50));
                Thread.sleep(2000L);
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

