/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.dao.EventRecordDao;
import cn.com.voltronic.solar.data.bean.EventData;
import cn.com.voltronic.solar.data.bean.EventDataRecord;
import cn.com.voltronic.solar.data.bean.EventStatisItem;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.view.ExcelFileFilter;
import cn.com.voltronic.solar.view.ExcelxFileFilter;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AACheckBox;
import cn.com.voltronic.solar.view.component.AADefaultTableModel;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import cn.com.voltronic.solar.view.component.I18NListener;
import cn.com.voltronic.solar.view.component.MyCalendarPanel;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.TextAnchor;

public class HistoryEventDialog
extends AADialog {
    private static final long serialVersionUID = -2752882145880558233L;
    private AAButton closeButton;
    private AAButton deleteAllButton;
    private AAButton deleteButton;
    private AAButton saveAsButton;
    private AAButton jButton3;
    private AACheckBox jCheckBox1;
    private JComboBox jComboBox1;
    private AALabel jLabel1;
    private AALabel jLabel2;
    private AALabel jLabel3;
    private AALabel jLabel4;
    private AALabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JTable jTable1;
    private JTable jTable2;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private boolean canDelete = false;
    private DefaultCategoryDataset dataset = null;
    private JFreeChart chart = null;
    private CategoryPlot categoryPlot = null;
    private JFileChooser fDialog;
    private EventRecordDao eventDao = null;
    private AADefaultTableModel tableModel1 = null;
    private AADefaultTableModel tableModel2 = null;
    private List<EventDataRecord> eventlist = new ArrayList<EventDataRecord>();
    private List<EventStatisItem> eventtotal = new ArrayList<EventStatisItem>();
    private final int MAX_SIZE = 22;
    private final int MAX_SIZE2 = 10;
    private final int MAX_COLUMN = 4;
    private String[] tableTile = new String[]{"ID", "message.level", "message.time", "message.eventName"};
    private String[] tableTile2 = new String[]{"ID", "message.level", "message.eventName", "message.count"};

    public HistoryEventDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("message.queryEvent");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.eventDao = new EventRecordDao();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new AALabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new AALabel();
        this.jTextField1 = new JTextField();
        this.jLabel3 = new AALabel();
        this.jLabel4 = new AALabel();
        this.jLabel5 = new AALabel();
        this.jButton3 = new AAButton();
        this.jTextField2 = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane2 = new JScrollPane();
        this.jScrollPane3 = new JScrollPane();
        this.jSeparator1 = new JSeparator();
        this.jCheckBox1 = new AACheckBox();
        this.jPanel2 = new JPanel();
        this.closeButton = new AAButton();
        this.deleteAllButton = new AAButton();
        this.deleteButton = new AAButton();
        this.saveAsButton = new AAButton();
        this.jTable1 = new JTable(){
            private static final long serialVersionUID = -2097364819095589911L;

            @Override
            public boolean isCellSelected(int row, int column) {
                if (row >= HistoryEventDialog.this.eventlist.size()) {
                    return false;
                }
                return super.isCellSelected(row, column);
            }
        };
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.getTableHeader().setForeground(Color.white);
        this.jTable1.setSelectionMode(0);
        this.tableModel1 = new AADefaultTableModel(new Object[22][4], this.tableTile){
            private static final long serialVersionUID = -4444769250474742659L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jTable1.setModel(this.tableModel1);
        this.jTable2 = new JTable(){
            private static final long serialVersionUID = 1813629617886543541L;

            @Override
            public boolean isCellSelected(int row, int column) {
                if (row >= HistoryEventDialog.this.eventtotal.size()) {
                    return false;
                }
                return super.isCellSelected(row, column);
            }
        };
        this.jTable2.getTableHeader().setReorderingAllowed(false);
        this.jTable2.getTableHeader().setForeground(Color.white);
        this.jTable2.setSelectionMode(0);
        this.tableModel2 = new AADefaultTableModel(new Object[10][4], this.tableTile2){
            private static final long serialVersionUID = 2752220891304139492L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jTable2.setModel(this.tableModel2);
        this.setTableFormate();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("message.device[:]");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(this.queryDevices()));
        this.jLabel2.setText("message.selectDate[:]");
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                HistoryEventDialog.this.canDelete = false;
            }
        });
        this.jLabel3.setIcon(new ImageIcon(Constants.DATE));
        this.jLabel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HistoryEventDialog.this.canDelete = false;
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryEventDialog.this.jTextField1);
                calendarPanel.setBounds(HistoryEventDialog.this.getX() + HistoryEventDialog.this.jLabel3.getX() + 30, HistoryEventDialog.this.getY() + HistoryEventDialog.this.jLabel3.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jTextField1.setEditable(false);
        this.jTextField1.setBackground(I18NListener.bgColor);
        this.jTextField1.setText(DateUtils.getNowDate());
        this.jTextField1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HistoryEventDialog.this.canDelete = false;
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryEventDialog.this.jTextField1);
                calendarPanel.setBounds(HistoryEventDialog.this.getX() + HistoryEventDialog.this.jLabel3.getX() + 30, HistoryEventDialog.this.getY() + HistoryEventDialog.this.jLabel3.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jLabel4.setText("--");
        this.jLabel5.setIcon(new ImageIcon(Constants.DATE));
        this.jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HistoryEventDialog.this.canDelete = false;
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryEventDialog.this.jTextField2);
                calendarPanel.setBounds(HistoryEventDialog.this.getX() + HistoryEventDialog.this.jLabel5.getX() + 30, HistoryEventDialog.this.getY() + HistoryEventDialog.this.jLabel5.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jTextField2.setEditable(false);
        this.jTextField2.setBackground(I18NListener.bgColor);
        this.jTextField2.setText(DateUtils.getNowDate());
        this.jTextField2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HistoryEventDialog.this.canDelete = false;
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryEventDialog.this.jTextField2);
                calendarPanel.setBounds(HistoryEventDialog.this.getX() + HistoryEventDialog.this.jLabel5.getX() + 30, HistoryEventDialog.this.getY() + HistoryEventDialog.this.jLabel5.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jCheckBox1.setText("message.includeinfo");
        this.jCheckBox1.setSelected(true);
        this.jButton3.setText("message.view");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryEventDialog.this.canDelete = true;
                HistoryEventDialog.this.queryHistoryEventRecord();
            }
        });
        this.deleteButton.setText("message.del");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                HistoryEventDialog.this.deleteEvents();
            }
        });
        this.deleteAllButton.setText("message.deleteAll");
        this.deleteAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                HistoryEventDialog.this.clearEvents();
            }
        });
        this.saveAsButton.setText("message.saveas");
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                HistoryEventDialog.this.saveAs();
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jScrollPane2.setViewportView(this.jTable2);
        try {
            this.dataset = new DefaultCategoryDataset();
            this.chart = ChartFactory.createBarChart((String)"", (String)"ID", (String)bd.getString("message.count"), (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            this.chart.setBackgroundPaint((Paint)Constants.BG_COLOR);
            this.categoryPlot = this.chart.getCategoryPlot();
            this.categoryPlot.setBackgroundPaint((Paint)Constants.BG_COLOR);
            this.categoryPlot.setDomainGridlinePaint((Paint)Constants.BG_COLOR);
            this.categoryPlot.setDomainGridlinesVisible(true);
            this.categoryPlot.setRangeGridlinePaint((Paint)Color.white);
            CategoryAxis categoryAxis = this.categoryPlot.getDomainAxis();
            categoryAxis.setLabelPaint((Paint)Color.white);
            categoryAxis.setTickLabelPaint((Paint)Color.white);
            ValueAxis rangeAxis = this.categoryPlot.getRangeAxis();
            rangeAxis.setUpperMargin(0.1);
            rangeAxis.setLabelPaint((Paint)Color.white);
            rangeAxis.setTickLabelPaint((Paint)Color.white);
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            BarRenderer barRenderer = (BarRenderer)this.categoryPlot.getRenderer();
            barRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
            barRenderer.setBaseItemLabelsVisible(true);
            barRenderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_CENTER));
            barRenderer.setItemLabelsVisible(true);
            barRenderer.setPaint((Paint)new Color(232, 107, 30));
            barRenderer.setMaxBarWidth(0.07);
            barRenderer.setItemLabelPaint((Paint)Color.white);
            ChartPanel chartPane = new ChartPanel(this.chart);
            chartPane.setPreferredSize(new Dimension(480, 250));
            this.jScrollPane3.setViewportView((Component)chartPane);
        }
        catch (Exception ex) {
            System.err.println("history event chart error");
        }
        this.jSeparator1.setOrientation(1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.saveAsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteAllButton)).addComponent(this.jScrollPane1, -2, 550, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 500, Short.MAX_VALUE).addComponent(this.jScrollPane3, -1, 500, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton3))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.jLabel2).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jCheckBox1).addComponent(this.jButton3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 500, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 240, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 260, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 465, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteAllButton).addComponent(this.deleteButton).addComponent(this.saveAsButton)))).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.closeButton.setText("message.close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryEventDialog.this.dispose();
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(730, Short.MAX_VALUE).addComponent(this.closeButton).addGap(12, 12, 12)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton)).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel2, "Last");
        this.pack();
    }

    public void queryHistoryEventRecord() {
        if (this.jComboBox1.getSelectedItem() != null) {
            String serialno = this.jComboBox1.getSelectedItem().toString().trim();
            String startDate = this.jTextField1.getText().trim();
            String endDate = this.jTextField2.getText().trim();
            boolean includeinfo = this.jCheckBox1.isSelected();
            if (!(serialno == null || "".equals(serialno) || startDate == null || "".equals(startDate) || endDate == null || "".equals(endDate))) {
                SimpleDateFormat format = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
                Date fromDate = new Date();
                Date toDate = new Date();
                try {
                    fromDate = format.parse(startDate);
                    toDate = format.parse(endDate);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.eventlist = this.eventDao.queryEvent(serialno, fromDate, toDate, includeinfo);
                this.eventtotal = this.eventDao.queryEventStatistics(serialno, fromDate, toDate, includeinfo);
                this.setTableLeft();
                this.setTableRight();
                this.setTableFormate();
                if (this.dataset != null) {
                    this.dataset.clear();
                }
                int i = 0;
                while (i < this.eventtotal.size()) {
                    this.dataset.addValue((double)this.eventtotal.get(i).getCount(), (Comparable)((Object)"ID"), (Comparable)((Object)this.eventtotal.get(i).getEventId()));
                    ++i;
                }
            }
        }
    }

    private void setTableRight() {
        int size = this.eventtotal.size();
        if (size < 10) {
            size = 10;
        }
        Object[][] obj = new Object[size][4];
        int i = 0;
        while (i < this.eventtotal.size()) {
            EventStatisItem eventStatisItem = this.eventtotal.get(i);
            int level = eventStatisItem.getLevel();
            String levelStr = "";
            if (level == 1) {
                levelStr = "message.fault";
            } else if (level == 2) {
                levelStr = "message.warning";
            } else if (level == 3) {
                levelStr = "message.info";
            }
            obj[i][0] = eventStatisItem.getEventId();
            obj[i][1] = levelStr;
            obj[i][2] = eventStatisItem.getName();
            obj[i][3] = eventStatisItem.getCount();
            ++i;
        }
        if (this.eventtotal.size() < 10) {
            i = this.eventtotal.size();
            while (i < 10) {
                int j = 0;
                while (j < 4) {
                    obj[i][j] = null;
                    ++j;
                }
                ++i;
            }
        }
        this.tableModel2.setDataVector(obj, this.tableTile2);
    }

    private void setTableLeft() {
        int size = this.eventlist.size();
        if (size < 22) {
            size = 22;
        }
        Object[][] obj = new Object[size][4];
        int i = 0;
        while (i < this.eventlist.size()) {
            EventData eventData = EventsHandler.getEventById(this.eventlist.get(i).getProdId(), this.eventlist.get(i).getEventId());
            int level = eventData.getEventLevel();
            String levelStr = "";
            if (level == 1) {
                levelStr = "message.fault";
            } else if (level == 2) {
                levelStr = "message.warning";
            } else if (level == 3) {
                levelStr = "message.info";
            }
            obj[i][0] = eventData.getEventId();
            obj[i][1] = levelStr;
            obj[i][2] = DateUtils.getFormatTimestamp(this.eventlist.get(i).getTrandate());
            obj[i][3] = eventData.getEventName();
            ++i;
        }
        if (this.eventlist.size() < 22) {
            i = this.eventlist.size();
            while (i < 22) {
                int j = 0;
                while (j < 4) {
                    obj[i][j] = null;
                    ++j;
                }
                ++i;
            }
        }
        this.tableModel1.setDataVector(obj, this.tableTile);
    }

    public void setTableFormate() {
        TableColumnModel tcm = this.jTable1.getColumnModel();
        TableColumn tc0 = tcm.getColumn(0);
        TableColumn tc1 = tcm.getColumn(1);
        TableColumn tc2 = tcm.getColumn(2);
        TableColumn tc3 = tcm.getColumn(3);
        tc0.setPreferredWidth(10);
        tc1.setPreferredWidth(25);
        tc2.setPreferredWidth(80);
        tc3.setPreferredWidth(250);
        TableColumnModel tcm2 = this.jTable2.getColumnModel();
        TableColumn tcc0 = tcm2.getColumn(0);
        TableColumn tcc1 = tcm2.getColumn(1);
        TableColumn tcc2 = tcm2.getColumn(2);
        TableColumn tcc3 = tcm2.getColumn(3);
        tcc0.setPreferredWidth(10);
        tcc1.setPreferredWidth(25);
        tcc2.setPreferredWidth(250);
        tcc3.setPreferredWidth(80);
    }

    public String[] queryDevices() {
        List<String> devicelist = this.eventDao.queryDevices();
        String[] devices = new String[devicelist.size()];
        int i = 0;
        while (i < devicelist.size()) {
            devices[i] = devicelist.get(i);
            ++i;
        }
        return devices;
    }

    public void deleteEvents() {
        if (this.jComboBox1.getSelectedItem() != null) {
            String serialno = this.jComboBox1.getSelectedItem().toString().trim();
            int re = DisplayMessage.showConfirmDialog("message.deleteConfirm", "message.info");
            if (re == 0 && serialno != null && !"".equals(serialno)) {
                int row = this.jTable1.getSelectedRow();
                if (row > -1) {
                    Object obj = this.tableModel1.getValueAt(row, 2);
                    Object obj2 = this.tableModel1.getValueAt(row, 0);
                    if (obj != null && obj2 != null) {
                        SimpleDateFormat sdf = new SimpleDateFormat(String.valueOf(GlobalVariables.globalConfig.getDateFormat()) + " HH:mm:ss");
                        Date trandate = new Date();
                        try {
                            trandate = sdf.parse(obj.toString().trim());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        String eventid = obj2.toString().trim();
                        boolean result = this.eventDao.deleteEventRecord(serialno, eventid, trandate);
                        if (result) {
                            this.queryHistoryEventRecord();
                        } else {
                            DisplayMessage.showErrorDialog("message.operationfailure");
                        }
                    } else {
                        DisplayMessage.showErrorDialog("message.pleaseselect");
                    }
                } else {
                    DisplayMessage.showErrorDialog("message.pleaseselect");
                }
            }
        }
    }

    public void clearEvents() {
        if (this.canDelete && this.jComboBox1.getSelectedItem() != null) {
            String serialno = this.jComboBox1.getSelectedItem().toString().trim();
            String startDate = this.jTextField1.getText().trim();
            String endDate = this.jTextField2.getText().trim();
            int re = DisplayMessage.showConfirmDialog("message.deleteConfirm", "message.info");
            if (!(re != 0 || serialno == null || "".equals(serialno) || startDate == null || "".equals(startDate) || endDate == null || "".equals(endDate))) {
                SimpleDateFormat format = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
                Date fromDate = new Date();
                Date toDate = new Date();
                try {
                    fromDate = format.parse(startDate);
                    toDate = format.parse(endDate);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                boolean result = this.eventDao.deleteEventRecordAll(serialno, fromDate, toDate);
                if (result) {
                    this.queryHistoryEventRecord();
                } else {
                    DisplayMessage.showErrorDialog("message.operationfailure");
                }
            }
        }
    }

    public int getSaveDialog() {
        Date date = new Date();
        String saveFileName = DateUtils.getFormatDate(date, "yyyyMMddHHmmss");
        this.fDialog = new JFileChooser();
        saveFileName = String.valueOf(saveFileName) + ".xls";
        ExcelFileFilter xls = new ExcelFileFilter();
        this.fDialog.addChoosableFileFilter(xls);
        ExcelxFileFilter xlsx = new ExcelxFileFilter();
        this.fDialog.setFileFilter(xlsx);
        this.fDialog.setAcceptAllFileFilterUsed(true);
        this.fDialog.setSelectedFile(new File(saveFileName));
        return this.fDialog.showSaveDialog(this);
    }

    public void saveAs() {
        int result = this.getSaveDialog();
        if (result == 0) {
            String filepathStr = this.fDialog.getSelectedFile().getPath();
            File newFile = new File(filepathStr);
            if (newFile.exists()) {
                int re = DisplayMessage.showConfirmDialog("message.confirmoverwrite", "message.info");
                if (re == 0) {
                    this.createExcel(newFile);
                } else {
                    this.saveAs();
                }
            } else {
                try {
                    newFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.createExcel(newFile);
            }
        }
    }

    public void createPdf(String path) {
        Document pdf = new Document(PageSize.A4);
        try {
            try {
                PdfWriter.getInstance((Document)pdf, (OutputStream)new FileOutputStream(path));
                pdf.addTitle("History event datas");
                pdf.addAuthor(GlobalVariables.customerConfig.getCustomerName());
                pdf.open();
                BaseFont bf = BaseFont.createFont((String)(String.valueOf(Constants.PDF_STYLE_PATH) + "simsun.ttc,1"), (String)"Identity-H", (boolean)false);
                Font datafont = new Font(bf, 12.0f, 0, BaseColor.BLACK);
                String[] titles = this.tableTile;
                PdfPTable table = new PdfPTable(titles.length);
                int i = 0;
                while (i < titles.length) {
                    PdfPCell cell = new PdfPCell((Phrase)new Paragraph(bd.getString(titles[i]), datafont));
                    cell.setHorizontalAlignment(1);
                    table.addCell(cell);
                    ++i;
                }
                i = 0;
                while (i < this.eventlist.size()) {
                    EventData eventData = EventsHandler.getEventById(this.eventlist.get(i).getProdId(), this.eventlist.get(i).getEventId());
                    int level = eventData.getEventLevel();
                    String levelStr = "";
                    if (level == 1) {
                        levelStr = "message.fault";
                    } else if (level == 2) {
                        levelStr = "message.warning";
                    } else if (level == 3) {
                        levelStr = "message.info";
                    }
                    table.addCell((Phrase)new Paragraph(eventData.getEventId(), datafont));
                    table.addCell((Phrase)new Paragraph(bd.getString(levelStr), datafont));
                    table.addCell((Phrase)new Paragraph(DateUtils.getFormatTimestamp(this.eventlist.get(i).getTrandate()), datafont));
                    table.addCell((Phrase)new Paragraph(eventData.getEventName(), datafont));
                    ++i;
                }
                table.setWidthPercentage(100.0f);
                pdf.add((Element)table);
                Thread.sleep(1500L);
            }
            catch (Exception ie) {
                DisplayMessage.showErrorDialog("message.saveerror");
                try {
                    if (pdf != null) {
                        pdf.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pdf != null) {
                    pdf.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void createExcel(File newFile) {
        WritableWorkbook wwb = null;
        try {
            try {
                wwb = Workbook.createWorkbook((File)newFile);
                WritableSheet ws = wwb.createSheet("History event datas", 0);
                WritableCellFormat cellFormat = new WritableCellFormat();
                cellFormat.setAlignment(Alignment.CENTRE);
                String[] titles = this.tableTile;
                int i = 0;
                while (i < titles.length) {
                    Label labelC = new Label(i, 0, bd.getString(titles[i]));
                    labelC.setCellFormat((CellFormat)cellFormat);
                    ws.addCell((WritableCell)labelC);
                    int length = bd.getString(titles[i]).length();
                    if (length >= 20) {
                        ws.setColumnView(i, length + 2);
                    } else {
                        ws.setColumnView(i, 22);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.eventlist.size()) {
                    EventData eventData = EventsHandler.getEventById(this.eventlist.get(i).getProdId(), this.eventlist.get(i).getEventId());
                    int level = eventData.getEventLevel();
                    String levelStr = "";
                    if (level == 1) {
                        levelStr = "message.fault";
                    } else if (level == 2) {
                        levelStr = "message.warning";
                    } else if (level == 3) {
                        levelStr = "message.info";
                    }
                    ws.addCell((WritableCell)new Label(0, i + 1, eventData.getEventId()));
                    ws.addCell((WritableCell)new Label(1, i + 1, bd.getString(levelStr)));
                    ws.addCell((WritableCell)new Label(2, i + 1, DateUtils.getFormatTimestamp(this.eventlist.get(i).getTrandate())));
                    ws.addCell((WritableCell)new Label(3, i + 1, eventData.getEventName()));
                    ++i;
                }
                wwb.write();
                Thread.sleep(1500L);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (wwb != null) {
                        wwb.close();
                    }
                }
                catch (WriteException e2) {
                    e2.printStackTrace();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (wwb != null) {
                    wwb.close();
                }
            }
            catch (WriteException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

