/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;

public class RealControlJDialog
extends AADialog {
    private static final long serialVersionUID = -5986305231916605918L;
    private AbstractProcessor processor = null;
    private AAButton cancelButton;
    private AAButton faultResetButton;
    private AALabel faultResetLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private AALabel onOffLabel;
    private JRadioButton turnoffButton;
    private JRadioButton turnonButton;
    private AAButton applyOnOffButton;

    public RealControlJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("message.realTimeCtrl");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.faultResetLabel = new AALabel();
        this.faultResetButton = new AAButton();
        this.jPanel2 = new JPanel();
        this.cancelButton = new AAButton();
        this.onOffLabel = new AALabel();
        this.turnoffButton = new JRadioButton();
        this.turnonButton = new JRadioButton();
        this.applyOnOffButton = new AAButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.faultResetLabel.setText("Reset fault");
        this.faultResetButton.setText("message.apply");
        this.faultResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                RealControlJDialog.this.resetFault(e);
            }
        });
        this.onOffLabel.setText("Remote");
        this.turnoffButton.setText("turn off");
        this.turnoffButton.setSelected(true);
        this.turnoffButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RealControlJDialog.this.turnoffButton.setSelected(true);
                RealControlJDialog.this.turnonButton.setSelected(false);
            }
        });
        this.turnonButton.setText("turn on");
        this.turnonButton.setSelected(false);
        this.turnonButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RealControlJDialog.this.turnoffButton.setSelected(false);
                RealControlJDialog.this.turnonButton.setSelected(true);
            }
        });
        this.applyOnOffButton.setText("message.apply");
        this.applyOnOffButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                RealControlJDialog.this.setRemoteControl(e);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.faultResetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.faultResetButton).addContainerGap(167, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.onOffLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.turnoffButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.turnonButton).addGap(6, 6, 6).addComponent(this.applyOnOffButton).addContainerGap(167, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(23, 23, 23).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.faultResetLabel).addComponent(this.faultResetButton)).addGap(23, 23, 23).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.onOffLabel).addComponent(this.turnoffButton).addComponent(this.turnonButton).addComponent(this.applyOnOffButton)).addContainerGap(203, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.cancelButton.setText("message.cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RealControlJDialog.this.dispose();
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(346, Short.MAX_VALUE).addComponent(this.cancelButton).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.cancelButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel2, "Last");
        this.pack();
    }

    private void resetFault(ActionEvent e) {
        this.faultResetButton.setEnabled(false);
        boolean result = false;
        if (this.processor == null) {
            this.processor = GlobalProcessors.getCurrentProcessor();
        }
        if (this.processor != null) {
            result = this.processor.executeControl("setResetFault", new Object[]{2048.0});
        }
        if (result) {
            DisplayMessage.showInfoDialog("message.setTrue");
        } else {
            DisplayMessage.showErrorDialog("message.setFalse");
        }
        this.faultResetButton.setEnabled(true);
    }

    private void setRemoteControl(ActionEvent e) {
        this.applyOnOffButton.setEnabled(false);
        boolean result = false;
        if (this.processor == null) {
            this.processor = GlobalProcessors.getCurrentProcessor();
        }
        if (this.processor != null) {
            if (this.turnoffButton.isSelected()) {
                result = this.processor.executeControl("setRemoteControl", new Object[]{4096.0});
            } else if (this.turnonButton.isSelected()) {
                result = this.processor.executeControl("setRemoteControl", new Object[]{2048.0});
            }
        }
        if (result) {
            DisplayMessage.showInfoDialog("message.setTrue");
        } else {
            DisplayMessage.showErrorDialog("message.setFalse");
        }
        this.applyOnOffButton.setEnabled(true);
    }
}

