/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.comm.ParallelPort;

public class BufferSize
extends Panel
implements MouseListener,
ActionListener {
    private int value;
    private int defaultValue;
    private Label label;
    private TextField data;
    private ParallelPort port = null;
    private boolean inputBuffer;

    public BufferSize(int n, ParallelPort parallelPort, boolean bl) {
        this.setPort(parallelPort);
        this.inputBuffer = bl;
        this.setLayout((LayoutManager)new BorderLayout());
        this.label = new Label("Buffer Size");
        this.label.addMouseListener((MouseListener)this);
        this.add("West", (Component)this.label);
        this.data = new TextField(new Integer(this.defaultValue).toString(), n);
        this.data.addActionListener((ActionListener)this);
        this.add("East", (Component)this.data);
        this.showValue();
        this.defaultValue = this.value;
    }

    public void setPort(ParallelPort parallelPort) {
        this.port = parallelPort;
    }

    public int getValue() {
        if (this.port != null) {
            this.value = this.inputBuffer ? this.port.getInputBufferSize() : this.port.getOutputBufferSize();
            return this.value;
        }
        return 0;
    }

    public void showValue() {
        this.data.setText(new Integer(this.getValue()).toString());
    }

    public void setValue(int n) {
        if (this.port != null) {
            if (this.inputBuffer) {
                this.port.setInputBufferSize(n);
            } else {
                this.port.setOutputBufferSize(n);
            }
        }
        this.showValue();
    }

    public void setDefaultValue(int n) {
        this.defaultValue = n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            Integer n = new Integer(string);
            this.setValue(n.intValue());
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Bad value = " + actionEvent.getActionCommand());
            this.showValue();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setValue(this.defaultValue);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

