/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.Portmapping;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class SolarisSerial
extends SerialPort {
    private int baud = 9600;
    private int databits = 8;
    private int stopbits = 1;
    private int parity = 0;
    private int flowcontrol = 0;
    private int port_fd = 0;
    protected boolean portInError = false;
    private SerialPortEventListener listener = null;
    private SolarisSerialCheckStatusThread CheckStatus = null;
    private SolarisSerialInputStream inputStream = null;
    private SolarisSerialOutputStream outputStream = null;
    private int rcvThreshold = -1;
    private int rcvTimeout = -1;
    byte[] tmprbuf;
    private boolean write_finished_flag = false;
    private Object write_finished_flag_lock = new Object();
    private SolarisSerialReaderThread readerThread = null;
    private static final int STATUS_DTR = 1;
    private static final int STATUS_RTS = 2;
    private static final int STATUS_CTS = 4;
    private static final int STATUS_DSR = 8;
    private static final int STATUS_RI = 16;
    private static final int STATUS_CD = 32;
    private static final int STATUS_DATA_AVAIL = 1;
    private static final int STATUS_OUTPUTEMPTY = 2;
    private int notificationMask = 0;
    private static final int NOTIFY_DataAvailable = 1;
    private static final int NOTIFY_OutputEmpty = 2;
    private static final int NOTIFY_CTS = 4;
    private static final int NOTIFY_DSR = 8;
    private static final int NOTIFY_RingIndicator = 16;
    private static final int NOTIFY_CarrierDetect = 32;
    private static final int NOTIFY_OverrunError = 64;
    private static final int NOTIFY_ParityError = 128;
    private static final int NOTIFY_FramingError = 256;
    private static final int NOTIFY_BreakInterrupt = 512;
    private int framing_byte = -1;
    private int ibuffer_size = 1024;
    private int obuffer_size = 1024;

    public SolarisSerial(String theName) throws IOException {
        this.name = theName;
        if (this.port_fd != 0) {
            return;
        }
        String portName = Portmapping.translatePortname(theName);
        if (System.getProperty("debug_portmap") != null) {
            System.err.println("SolarisSerial(" + theName + ") = " + portName);
        }
        try {
            this.port_fd = this.openNativePort(portName);
        }
        catch (IOException e) {
            throw new IOException("  Error opening \"" + portName + "\"\n  " + e.getMessage());
        }
        try {
            this.setNativeSerialPortParams(this.port_fd, 1, this.baud, this.databits, this.stopbits, this.parity, this.flowcontrol);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            // empty catch block
        }
        this.tmprbuf = new byte[1];
        this.readerThread = new SolarisSerialReaderThread();
        this.readerThread.start();
    }

    private native void nWaitForEvent(int var1);

    private native int nCheckBreak(int var1);

    private native int nCheckParityErrors(int var1);

    private native int nReaderThread(int var1);

    protected void finalize() {
        this.close();
    }

    public int getBaudRate() {
        if (this.port_fd != 0) {
            return this.nativeGetBaudRate(this.port_fd);
        }
        throw new IllegalStateException("This port is closed");
    }

    public int getDataBits() {
        if (this.port_fd != 0) {
            return this.nativeGetDataBits(this.port_fd);
        }
        throw new IllegalStateException("This port is closed");
    }

    public int getStopBits() {
        if (this.port_fd != 0) {
            return this.nativeGetStopBits(this.port_fd);
        }
        throw new IllegalStateException("This port is closed");
    }

    public int getParity() {
        if (this.port_fd != 0) {
            return this.nativeGetParity(this.port_fd);
        }
        throw new IllegalStateException("This port is closed");
    }

    private native int nativeGetBaudRate(int var1);

    private native int nativeGetDataBits(int var1);

    private native int nativeGetStopBits(int var1);

    private native int nativeGetParity(int var1);

    public void sendBreak(int millis) {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        this.nativeSendBreak(this.port_fd);
    }

    private native void nativeSendBreak(int var1);

    public void setFlowControlMode(int FlowControl) throws UnsupportedCommOperationException {
        try {
            if (this.port_fd != 0) {
                if ((FlowControl & 1) != 0 ? (FlowControl & 8) != 0 || (FlowControl & 4) != 0 : (FlowControl & 2) != 0 && ((FlowControl & 4) != 0 || (FlowControl & 8) != 0)) {
                    throw new UnsupportedCommOperationException("Cannot mix hardware and software flow control");
                }
            } else {
                throw new IllegalStateException("This port is closed");
            }
            this.setNativeSerialPortParams(this.port_fd, 0, this.baud, this.databits, this.stopbits, this.parity, FlowControl);
            this.flowcontrol = FlowControl;
        }
        catch (UnsupportedCommOperationException ucoe) {
            ucoe.printStackTrace();
        }
    }

    public int getFlowControlMode() {
        if (this.port_fd != 0) {
            return this.nativeGetFlowctrl(this.port_fd);
        }
        throw new IllegalStateException("This port is closed");
    }

    private native int nativeGetFlowctrl(int var1);

    public void setSerialPortParams(int baud, int databits, int stopbits, int parity) throws UnsupportedCommOperationException {
        if (databits != 5 && databits != 6 && databits != 7 && databits != 8) {
            throw new UnsupportedCommOperationException("Unsupported number of databits");
        }
        if (stopbits != 1 && stopbits != 2) {
            throw new UnsupportedCommOperationException("Unsupported number of stopbits" + stopbits);
        }
        if (parity != 2 && parity != 1 && parity != 0) {
            throw new UnsupportedCommOperationException("Unsupported parity value");
        }
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        this.setNativeSerialPortParams(this.port_fd, 0, baud, databits, stopbits, parity, this.flowcontrol);
        this.baud = baud;
        this.databits = databits;
        this.stopbits = stopbits;
        this.parity = parity;
    }

    private native void setNativeSerialPortParams(int var1, int var2, int var3, int var4, int var5, int var6, int var7) throws UnsupportedCommOperationException;

    public void setDTR(boolean dtr) {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        this.nativeSetDTR(this.port_fd, dtr);
    }

    public native void nativeSetDTR(int var1, boolean var2);

    public void setRTS(boolean rts) {
        if (this.port_fd != 0) {
            if ((this.flowcontrol & 1) == 1) {
                throw new IllegalStateException("Cannot modify RTS when Hardware flowcontrol is on.");
            }
        } else {
            throw new IllegalStateException("This port is closed");
        }
        this.nativeSetRTS(this.port_fd, rts);
    }

    public native void nativeSetRTS(int var1, boolean var2);

    public boolean isDTR() {
        if (this.port_fd != 0) {
            return (this.getStatusFlags(this.port_fd) & 1) > 0;
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isRTS() {
        if (this.port_fd != 0) {
            return (this.getStatusFlags(this.port_fd) & 2) > 0;
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isCTS() {
        if (this.port_fd != 0) {
            return (this.getStatusFlags(this.port_fd) & 4) > 0;
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isDSR() {
        if (this.port_fd != 0) {
            return (this.getStatusFlags(this.port_fd) & 8) > 0;
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isRI() {
        if (this.port_fd != 0) {
            return (this.getStatusFlags(this.port_fd) & 0x10) > 0;
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isCD() {
        if (this.port_fd != 0) {
            return (this.getStatusFlags(this.port_fd) & 0x20) > 0;
        }
        throw new IllegalStateException("This port is closed");
    }

    private native int getStatusFlags(int var1);

    public void addEventListener(SerialPortEventListener lsnr) throws TooManyListenersException {
        if (this.port_fd != 0) {
            if (this.listener != null) {
                throw new TooManyListenersException("Only one listener is allowed");
            }
            this.listener = lsnr;
            if (this.CheckStatus == null) {
                this.CheckStatus = new SolarisSerialCheckStatusThread(this, lsnr);
            }
        } else {
            throw new IllegalStateException("This port is closed");
        }
        this.CheckStatus.start();
    }

    public void removeEventListener() {
        this.listener = null;
        this.port_fd = 0;
    }

    public void notifyOnDataAvailable(boolean enable) {
        this.notificationMask &= 0xFFFFFFFE;
        if (enable) {
            this.notificationMask |= 1;
        }
    }

    public void notifyOnOutputEmpty(boolean enable) {
        this.notificationMask &= 0xFFFFFFFD;
        if (enable) {
            this.notificationMask |= 2;
        }
    }

    public void notifyOnCTS(boolean enable) {
        this.notificationMask &= 0xFFFFFFFB;
        if (enable) {
            this.notificationMask |= 4;
        }
    }

    public void notifyOnDSR(boolean enable) {
        this.notificationMask &= 0xFFFFFFF7;
        if (enable) {
            this.notificationMask |= 8;
        }
    }

    public void notifyOnRingIndicator(boolean enable) {
        this.notificationMask &= 0xFFFFFFEF;
        if (enable) {
            this.notificationMask |= 0x10;
        }
    }

    public void notifyOnCarrierDetect(boolean enable) {
        this.notificationMask &= 0xFFFFFFDF;
        if (enable) {
            this.notificationMask |= 0x20;
        }
    }

    public void notifyOnOverrunError(boolean enable) {
        this.notificationMask &= 0xFFFFFFBF;
        if (enable) {
            this.notificationMask |= 0x40;
        }
    }

    public void notifyOnParityError(boolean enable) {
        this.notificationMask &= 0xFFFFFF7F;
        if (enable) {
            this.notificationMask |= 0x80;
        }
    }

    public void notifyOnFramingError(boolean enable) {
        this.notificationMask &= 0xFFFFFEFF;
        if (enable) {
            this.notificationMask |= 0x100;
        }
    }

    public void notifyOnBreakInterrupt(boolean enable) {
        this.notificationMask &= 0xFFFFFDFF;
        if (enable) {
            this.notificationMask |= 0x200;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.port_fd != 0) {
            if (this.inputStream == null) {
                this.inputStream = new SolarisSerialInputStream();
            }
            return this.inputStream;
        }
        throw new IllegalStateException("This port is closed");
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.port_fd != 0) {
            if (this.outputStream == null) {
                this.outputStream = new SolarisSerialOutputStream();
            }
            return this.outputStream;
        }
        throw new IllegalStateException("This port is closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.port_fd == 0) {
            super.close();
            return;
        }
        try {
            if (this.port_fd > 0) {
                this.closeNativePort(this.port_fd);
                this.port_fd = 0;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            super.close();
        }
    }

    private native int openNativePort(String var1) throws IOException;

    private native void closeNativePort(int var1) throws IOException;

    private native int available(int var1) throws IOException;

    private native int read(int var1, byte[] var2, int var3, int var4, int var5, int var6) throws IOException;

    private native int write(int var1, byte[] var2, int var3, int var4) throws IOException;

    private native int flush(int var1);

    public void enableReceiveThreshold(int thresh) throws UnsupportedCommOperationException {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        if (thresh < 0) {
            throw new UnsupportedCommOperationException("This threshold value is not supported");
        }
        this.rcvThreshold = thresh;
    }

    public void disableReceiveThreshold() {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        this.rcvThreshold = -1;
    }

    public boolean isReceiveThresholdEnabled() {
        return this.rcvThreshold >= 0;
    }

    public int getReceiveThreshold() {
        return this.rcvThreshold;
    }

    public void enableReceiveTimeout(int rcvTimeout) throws UnsupportedCommOperationException {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        if (rcvTimeout < 0) {
            throw new UnsupportedCommOperationException("This timeout value is not supported");
        }
        this.rcvTimeout = rcvTimeout;
    }

    public void disableReceiveTimeout() {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        this.rcvTimeout = -1;
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.rcvTimeout > 0;
    }

    public int getReceiveTimeout() {
        return this.rcvTimeout;
    }

    private native void nSetFramingByte(int var1, int var2);

    public void disableReceiveFraming() {
        this.framing_byte = -1;
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        this.nSetFramingByte(this.port_fd, this.framing_byte);
    }

    public void enableReceiveFraming(int framingByte) throws UnsupportedCommOperationException {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        this.framing_byte = framingByte & 0xFF;
        this.nSetFramingByte(this.port_fd, this.framing_byte);
    }

    public boolean isReceiveFramingEnabled() {
        return this.framing_byte != -1;
    }

    public int getReceiveFramingByte() {
        return this.framing_byte;
    }

    public void setInputBufferSize(int size) {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        this.ibuffer_size = size;
    }

    public int getInputBufferSize() {
        return this.ibuffer_size;
    }

    public void setOutputBufferSize(int size) {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        this.obuffer_size = size;
    }

    public int getOutputBufferSize() {
        return this.obuffer_size;
    }

    private class SolarisSerialReaderThread
    extends Thread {
        private SolarisSerialReaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (SolarisSerial.this.nReaderThread(SolarisSerial.this.port_fd) < 0) {
                SolarisSerial solarisSerial = SolarisSerial.this;
                synchronized (solarisSerial) {
                    SolarisSerial.this.portInError = true;
                }
            }
        }
    }

    public class SolarisSerialCheckStatusThread
    extends Thread {
        private boolean lastCD;
        private boolean lastRI;
        private boolean lastCTS;
        private boolean lastDSR;
        private boolean lastOE;
        private boolean lastPE;
        private boolean lastFE;
        private boolean lastBI;
        private SolarisSerial SSport;

        SolarisSerialCheckStatusThread(SolarisSerial serialPort, SerialPortEventListener lnsr) {
            this.SSport = serialPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.lastCD = SolarisSerial.this.isCD();
            this.lastRI = SolarisSerial.this.isRI();
            this.lastDSR = SolarisSerial.this.isDSR();
            this.lastCTS = SolarisSerial.this.isCTS();
            while (SolarisSerial.this.port_fd != 0) {
                boolean newRI;
                SolarisSerial solarisSerial = SolarisSerial.this;
                synchronized (solarisSerial) {
                    if (SolarisSerial.this.portInError) {
                        SolarisSerial.this.close();
                        this.RaiseEvent(SolarisSerial.this.notificationMask, 1, this.SSport, 1, false, true);
                        break;
                    }
                }
                SolarisSerial.this.nWaitForEvent(SolarisSerial.this.port_fd);
                if (SolarisSerial.this.port_fd == 0) break;
                try {
                    if (SolarisSerial.this.available(SolarisSerial.this.port_fd) > 0) {
                        this.RaiseEvent(SolarisSerial.this.notificationMask, 1, this.SSport, 1, false, true);
                    }
                }
                catch (IOException ex) {
                    System.err.println(ex + " trying to send data avail ev");
                }
                if (SolarisSerial.this.port_fd == 0) break;
                Object ex = SolarisSerial.this.write_finished_flag_lock;
                synchronized (ex) {
                    if (SolarisSerial.this.write_finished_flag) {
                        SolarisSerial.this.write_finished_flag = false;
                        this.RaiseEvent(SolarisSerial.this.notificationMask, 2, this.SSport, 2, false, true);
                    }
                }
                if (SolarisSerial.this.port_fd == 0) break;
                int nbrks = SolarisSerial.this.nCheckBreak(SolarisSerial.this.port_fd);
                if (nbrks > 0) {
                    while (nbrks-- > 0) {
                        this.RaiseEvent(SolarisSerial.this.notificationMask, 512, this.SSport, 10, false, true);
                        if (SolarisSerial.this.port_fd != 0) continue;
                    }
                }
                if (SolarisSerial.this.port_fd == 0) break;
                int npar = SolarisSerial.this.nCheckParityErrors(SolarisSerial.this.port_fd);
                if (npar > 0) {
                    while (npar-- > 0) {
                        this.RaiseEvent(SolarisSerial.this.notificationMask, 128, this.SSport, 8, false, true);
                        if (SolarisSerial.this.port_fd != 0) continue;
                    }
                }
                if (SolarisSerial.this.port_fd == 0) break;
                int statusFlag = SolarisSerial.this.getStatusFlags(SolarisSerial.this.port_fd);
                boolean newCD = (statusFlag & 0x20) > 0;
                boolean newDSR = (statusFlag & 8) > 0;
                boolean newCTS = (statusFlag & 4) > 0;
                boolean bl = newRI = (statusFlag & 0x10) > 0;
                if (newCD != this.lastCD) {
                    this.RaiseEvent(SolarisSerial.this.notificationMask, 32, this.SSport, 6, this.lastCD, newCD);
                }
                if (SolarisSerial.this.port_fd == 0) break;
                if (newDSR != this.lastDSR) {
                    this.RaiseEvent(SolarisSerial.this.notificationMask, 8, this.SSport, 4, this.lastDSR, newDSR);
                }
                if (SolarisSerial.this.port_fd == 0) break;
                if (newCTS != this.lastCTS) {
                    this.RaiseEvent(SolarisSerial.this.notificationMask, 4, this.SSport, 3, this.lastCTS, newCTS);
                }
                if (SolarisSerial.this.port_fd == 0) break;
                if (newRI != this.lastRI) {
                    this.RaiseEvent(SolarisSerial.this.notificationMask, 16, this.SSport, 5, this.lastRI, newRI);
                }
                if (SolarisSerial.this.port_fd == 0) break;
                this.lastCD = newCD;
                this.lastDSR = newDSR;
                this.lastCTS = newCTS;
                this.lastRI = newRI;
            }
        }

        private void RaiseEvent(int notificationMask, int event_notify_bit, SolarisSerial SSport, int event, boolean lastValue, boolean newValue) {
            if (SolarisSerial.this.listener != null && lastValue != newValue && (notificationMask & event_notify_bit) != 0) {
                SolarisSerial.this.listener.serialEvent(new SerialPortEvent(SSport, event, lastValue, newValue));
            }
        }
    }

    public class SolarisSerialOutputStream
    extends OutputStream {
        private boolean open = true;

        public void close() {
            this.open = false;
        }

        public void write(int b) throws IOException {
            byte[] buf = new byte[]{(byte)b};
            this.write(buf, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void write(byte[] b, int offset, int len) throws IOException {
            int write_up_to = len;
            int status = 0;
            if (!this.open) throw new IOException("This output stream is closed");
            if (SolarisSerial.this.port_fd == 0) throw new IOException("This port is closed");
            if (b == null) return;
            if (len + offset > b.length) {
                write_up_to = b.length - offset;
            }
            status = SolarisSerial.this.write(SolarisSerial.this.port_fd, b, offset, write_up_to);
            Object object = SolarisSerial.this.write_finished_flag_lock;
            synchronized (object) {
                SolarisSerial.this.write_finished_flag = true;
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void flush() throws IOException {
            int status = -1;
            if (!this.open) throw new IOException("This output stream is closed");
            if (SolarisSerial.this.port_fd == 0) throw new IOException("This port is closed");
            status = SolarisSerial.this.flush(SolarisSerial.this.port_fd);
            if (status != -1) return;
            throw new IOException("failed to flush output stream");
        }
    }

    public class SolarisSerialInputStream
    extends InputStream {
        private byte[] buf = null;
        private int pos = -1;

        public int available() throws IOException {
            if (SolarisSerial.this.portInError) {
                return Integer.MAX_VALUE;
            }
            if (SolarisSerial.this.port_fd != 0) {
                return SolarisSerial.this.available(SolarisSerial.this.port_fd);
            }
            throw new IOException("This port is closed");
        }

        public int read(byte[] b, int offset, int len) throws IOException {
            int read_up_to = len;
            int status = 0;
            if (b == null) {
                b = new byte[len + offset];
            }
            if (len + offset > b.length) {
                read_up_to = b.length - offset;
            }
            if (SolarisSerial.this.port_fd != 0) {
                status = SolarisSerial.this.read(SolarisSerial.this.port_fd, b, offset, read_up_to, SolarisSerial.this.rcvTimeout, SolarisSerial.this.rcvThreshold);
                return status;
            }
            throw new IOException("This port is closed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            int ret = 0;
            SolarisSerialInputStream solarisSerialInputStream = this;
            synchronized (solarisSerialInputStream) {
                if (SolarisSerial.this.portInError) {
                    this.close();
                    throw new IOException("Port closed due to error");
                }
            }
            if (SolarisSerial.this.port_fd != 0) {
                ret = SolarisSerial.this.read(SolarisSerial.this.port_fd, SolarisSerial.this.tmprbuf, 0, 1, SolarisSerial.this.rcvTimeout, SolarisSerial.this.rcvThreshold);
                if (ret == 1) {
                    return SolarisSerial.this.tmprbuf[0] & 0xFF;
                }
                return -1;
            }
            throw new IOException("This port is closed");
        }
    }
}

