/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class Platform {
    public static final String MAC = "Mac";
    public static final String WINDOWS = "Win";
    public static final String X11 = "X11";
    public static final String GTK = "Gtk";
    public static final String UNKNOWN = "unknown";
    private static String type = null;

    public static synchronized String DeterminePlatform() {
        if (type == null) {
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("glass.platform");
                }
            });
            if (string != null) {
                type = string.equals("macosx") ? MAC : (string.equals("windows") ? WINDOWS : (string.equals("linux") ? GTK : (string.equals("x11") ? X11 : (string.equals("gtk") ? GTK : string))));
                return type;
            }
            String string2 = System.getProperty("os.name");
            String string3 = string2.toLowerCase();
            if (string3.startsWith("mac") || string3.startsWith("darwin")) {
                type = MAC;
            } else if (string3.startsWith("wind")) {
                type = WINDOWS;
            } else if (string3.startsWith("linux")) {
                type = GTK;
            }
        }
        return type;
    }
}

