/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.binding;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.binding.HTTPBindingImpl;
import com.sun.xml.internal.ws.binding.SOAPBindingImpl;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.client.HandlerConfiguration;
import com.sun.xml.internal.ws.developer.BindingTypeFeature;
import com.sun.xml.internal.ws.developer.MemberSubmissionAddressingFeature;
import java.util.Collections;
import java.util.List;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.AddressingFeature;

public abstract class BindingImpl
implements WSBinding {
    protected HandlerConfiguration handlerConfig;
    private final BindingID bindingId;
    protected final WebServiceFeatureList features = new WebServiceFeatureList();
    protected Service.Mode serviceMode = Service.Mode.PAYLOAD;

    protected BindingImpl(BindingID bindingID) {
        this.bindingId = bindingID;
        this.handlerConfig = new HandlerConfiguration(Collections.emptySet(), Collections.emptyList());
    }

    @Override
    @NotNull
    public List<Handler> getHandlerChain() {
        return this.handlerConfig.getHandlerChain();
    }

    public HandlerConfiguration getHandlerConfig() {
        return this.handlerConfig;
    }

    public void setMode(@NotNull Service.Mode mode) {
        this.serviceMode = Service.Mode.MESSAGE;
    }

    @Override
    @NotNull
    public BindingID getBindingId() {
        return this.bindingId;
    }

    @Override
    public final SOAPVersion getSOAPVersion() {
        return this.bindingId.getSOAPVersion();
    }

    @Override
    public AddressingVersion getAddressingVersion() {
        AddressingVersion addressingVersion = this.features.isEnabled(AddressingFeature.class) ? AddressingVersion.W3C : (this.features.isEnabled(MemberSubmissionAddressingFeature.class) ? AddressingVersion.MEMBER : null);
        return addressingVersion;
    }

    @NotNull
    public final Codec createCodec() {
        BindingImpl.initializeJavaActivationHandlers();
        return this.bindingId.createEncoder(this);
    }

    public static BindingImpl create(@NotNull BindingID bindingID) {
        if (bindingID.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingID);
    }

    public static BindingImpl create(@NotNull BindingID bindingID, WebServiceFeature[] webServiceFeatureArray) {
        for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
            if (!(webServiceFeature instanceof BindingTypeFeature)) continue;
            BindingTypeFeature bindingTypeFeature = (BindingTypeFeature)webServiceFeature;
            bindingID = BindingID.parse(bindingTypeFeature.getBindingId());
        }
        if (bindingID.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingID, webServiceFeatureArray);
    }

    public static WSBinding getDefaultBinding() {
        return new SOAPBindingImpl(BindingID.SOAP11_HTTP);
    }

    @Override
    public String getBindingID() {
        return this.bindingId.toString();
    }

    @Override
    @Nullable
    public <F extends WebServiceFeature> F getFeature(@NotNull Class<F> clazz) {
        return this.features.get(clazz);
    }

    @Override
    public boolean isFeatureEnabled(@NotNull Class<? extends WebServiceFeature> clazz) {
        return this.features.isEnabled(clazz);
    }

    @Override
    @NotNull
    public WebServiceFeatureList getFeatures() {
        return this.features;
    }

    public void setFeatures(WebServiceFeature ... webServiceFeatureArray) {
        if (webServiceFeatureArray != null) {
            for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
                this.features.add(webServiceFeature);
            }
        }
    }

    public void addFeature(@NotNull WebServiceFeature webServiceFeature) {
        this.features.add(webServiceFeature);
    }

    public static void initializeJavaActivationHandlers() {
        try {
            MailcapCommandMap mailcapCommandMap;
            CommandMap commandMap = CommandMap.getDefaultCommandMap();
            if (commandMap instanceof MailcapCommandMap && !BindingImpl.cmdMapInitialized(mailcapCommandMap = (MailcapCommandMap)commandMap)) {
                mailcapCommandMap.addMailcap("text/xml;;x-java-content-handler=com.sun.xml.internal.ws.encoding.XmlDataContentHandler");
                mailcapCommandMap.addMailcap("application/xml;;x-java-content-handler=com.sun.xml.internal.ws.encoding.XmlDataContentHandler");
                mailcapCommandMap.addMailcap("image/*;;x-java-content-handler=com.sun.xml.internal.ws.encoding.ImageDataContentHandler");
                mailcapCommandMap.addMailcap("text/plain;;x-java-content-handler=com.sun.xml.internal.ws.encoding.StringDataContentHandler");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean cmdMapInitialized(MailcapCommandMap mailcapCommandMap) {
        CommandInfo[] commandInfoArray = mailcapCommandMap.getAllCommands("text/xml");
        if (commandInfoArray == null || commandInfoArray.length == 0) {
            return false;
        }
        String string = "com.sun.xml.internal.messaging.saaj.soap.XmlDataContentHandler";
        String string2 = "com.sun.xml.internal.ws.encoding.XmlDataContentHandler";
        for (CommandInfo commandInfo : commandInfoArray) {
            String string3 = commandInfo.getCommandClass();
            if (!string.equals(string3) && !string2.equals(string3)) continue;
            return true;
        }
        return false;
    }
}

