/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public class Logger {
    private static final Handler[] emptyHandlers = new Handler[0];
    private static final int offValue = Level.OFF.intValue();
    private volatile LogManager manager;
    private String name;
    private final CopyOnWriteArrayList<Handler> handlers = new CopyOnWriteArrayList();
    private volatile String resourceBundleName;
    private volatile boolean useParentHandlers = true;
    private volatile Filter filter;
    private boolean anonymous;
    private ResourceBundle catalog;
    private String catalogName;
    private Locale catalogLocale;
    private static final Object treeLock = new Object();
    private volatile Logger parent;
    private ArrayList<LogManager.LoggerWeakRef> kids;
    private volatile Level levelObject;
    private volatile int levelValue;
    private WeakReference<ClassLoader> callersClassLoaderRef;
    private final boolean isSystemLogger;
    public static final String GLOBAL_LOGGER_NAME = "global";
    @Deprecated
    public static final Logger global = new Logger("global");
    static final String SYSTEM_LOGGER_RB_NAME = "sun.util.logging.resources.logging";

    public static final Logger getGlobal() {
        return global;
    }

    protected Logger(String string, String string2) {
        this(string, string2, null, false);
    }

    Logger(String string, String string2, Class<?> clazz, boolean bl) {
        this.manager = LogManager.getLogManager();
        this.isSystemLogger = bl;
        this.setupResourceInfo(string2, clazz);
        this.name = string;
        this.levelValue = Level.INFO.intValue();
    }

    private void setCallersClassLoaderRef(Class<?> clazz) {
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = clazz != null ? clazz.getClassLoader() : null;
        if (classLoader != null) {
            this.callersClassLoaderRef = new WeakReference<ClassLoader>(classLoader);
        }
    }

    private ClassLoader getCallersClassLoader() {
        return this.callersClassLoaderRef != null ? (ClassLoader)this.callersClassLoaderRef.get() : null;
    }

    private Logger(String string) {
        this.name = string;
        this.isSystemLogger = true;
        this.levelValue = Level.INFO.intValue();
    }

    void setLogManager(LogManager logManager) {
        this.manager = logManager;
    }

    private void checkPermission() throws SecurityException {
        if (!this.anonymous) {
            if (this.manager == null) {
                this.manager = LogManager.getLogManager();
            }
            this.manager.checkPermission();
        }
    }

    private static Logger demandLogger(String string, String string2, Class<?> clazz) {
        LogManager logManager = LogManager.getLogManager();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && !LoggerHelper.disableCallerCheck && clazz.getClassLoader() == null) {
            return logManager.demandSystemLogger(string, string2);
        }
        return logManager.demandLogger(string, string2, clazz);
    }

    @CallerSensitive
    public static Logger getLogger(String string) {
        return Logger.demandLogger(string, null, Reflection.getCallerClass());
    }

    @CallerSensitive
    public static Logger getLogger(String string, String string2) {
        Class clazz = Reflection.getCallerClass();
        Logger logger = Logger.demandLogger(string, string2, clazz);
        if (logger.resourceBundleName == null) {
            logger.setupResourceInfo(string2, clazz);
        } else if (!logger.resourceBundleName.equals(string2)) {
            throw new IllegalArgumentException(logger.resourceBundleName + " != " + string2);
        }
        return logger;
    }

    static Logger getPlatformLogger(String string) {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.demandSystemLogger(string, SYSTEM_LOGGER_RB_NAME);
        return logger;
    }

    public static Logger getAnonymousLogger() {
        return Logger.getAnonymousLogger(null);
    }

    @CallerSensitive
    public static Logger getAnonymousLogger(String string) {
        LogManager logManager = LogManager.getLogManager();
        logManager.drainLoggerRefQueueBounded();
        Logger logger = new Logger(null, string, Reflection.getCallerClass(), false);
        logger.anonymous = true;
        Logger logger2 = logManager.getLogger("");
        logger.doSetParent(logger2);
        return logger;
    }

    public ResourceBundle getResourceBundle() {
        return this.findResourceBundle(this.getResourceBundleName(), true);
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setFilter(Filter filter) throws SecurityException {
        this.checkPermission();
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void log(LogRecord logRecord) {
        if (logRecord.getLevel().intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        Filter filter = this.filter;
        if (filter != null && !filter.isLoggable(logRecord)) {
            return;
        }
        Logger logger = this;
        while (logger != null) {
            boolean bl;
            Handler[] handlerArray;
            for (Handler handler : handlerArray = this.isSystemLogger ? logger.accessCheckedHandlers() : logger.getHandlers()) {
                handler.publish(logRecord);
            }
            boolean bl2 = bl = this.isSystemLogger ? logger.useParentHandlers : logger.getUseParentHandlers();
            if (!bl) break;
            logger = this.isSystemLogger ? logger.parent : logger.getParent();
        }
    }

    private void doLog(LogRecord logRecord) {
        logRecord.setLoggerName(this.name);
        String string = this.getEffectiveResourceBundleName();
        if (string != null && !string.equals(SYSTEM_LOGGER_RB_NAME)) {
            logRecord.setResourceBundleName(string);
            logRecord.setResourceBundle(this.findResourceBundle(string, true));
        }
        this.log(logRecord);
    }

    public void log(Level level, String string) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Object object) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        Object[] objectArray = new Object[]{object};
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Object[] objectArray) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Throwable throwable) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Object object) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        Object[] objectArray = new Object[]{object};
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Object[] objectArray) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Throwable throwable) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    private void doLog(LogRecord logRecord, String string) {
        logRecord.setLoggerName(this.name);
        if (string != null) {
            logRecord.setResourceBundleName(string);
            logRecord.setResourceBundle(this.findResourceBundle(string, false));
        }
        this.log(logRecord);
    }

    public void logrb(Level level, String string, String string2, String string3, String string4) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        this.doLog(logRecord, string3);
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object object) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        Object[] objectArray = new Object[]{object};
        logRecord.setParameters(objectArray);
        this.doLog(logRecord, string3);
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setParameters(objectArray);
        this.doLog(logRecord, string3);
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord, string3);
    }

    public void entering(String string, String string2) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, string, string2, "ENTRY");
    }

    public void entering(String string, String string2, Object object) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] objectArray = new Object[]{object};
        this.logp(Level.FINER, string, string2, "ENTRY {0}", objectArray);
    }

    public void entering(String string, String string2, Object[] objectArray) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        String string3 = "ENTRY";
        if (objectArray == null) {
            this.logp(Level.FINER, string, string2, string3);
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            string3 = string3 + " {" + i + "}";
        }
        this.logp(Level.FINER, string, string2, string3, objectArray);
    }

    public void exiting(String string, String string2) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, string, string2, "RETURN");
    }

    public void exiting(String string, String string2, Object object) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] objectArray = new Object[]{object};
        this.logp(Level.FINER, string, string2, "RETURN {0}", object);
    }

    public void throwing(String string, String string2, Throwable throwable) {
        if (Level.FINER.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(Level.FINER, "THROW");
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    public void severe(String string) {
        if (Level.SEVERE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.SEVERE, string);
    }

    public void warning(String string) {
        if (Level.WARNING.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.WARNING, string);
    }

    public void info(String string) {
        if (Level.INFO.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.INFO, string);
    }

    public void config(String string) {
        if (Level.CONFIG.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.CONFIG, string);
    }

    public void fine(String string) {
        if (Level.FINE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINE, string);
    }

    public void finer(String string) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, string);
    }

    public void finest(String string) {
        if (Level.FINEST.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINEST, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(Level level) throws SecurityException {
        this.checkPermission();
        Object object = treeLock;
        synchronized (object) {
            this.levelObject = level;
            this.updateEffectiveLevel();
        }
    }

    public Level getLevel() {
        return this.levelObject;
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.levelValue && this.levelValue != offValue;
    }

    public String getName() {
        return this.name;
    }

    public void addHandler(Handler handler) throws SecurityException {
        handler.getClass();
        this.checkPermission();
        this.handlers.add(handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        this.checkPermission();
        if (handler == null) {
            return;
        }
        this.handlers.remove(handler);
    }

    public Handler[] getHandlers() {
        return this.accessCheckedHandlers();
    }

    Handler[] accessCheckedHandlers() {
        return this.handlers.toArray(emptyHandlers);
    }

    public void setUseParentHandlers(boolean bl) {
        this.checkPermission();
        this.useParentHandlers = bl;
    }

    public boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    private static ResourceBundle findSystemResourceBundle(final Locale locale) {
        return AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

            @Override
            public ResourceBundle run() {
                try {
                    return ResourceBundle.getBundle(Logger.SYSTEM_LOGGER_RB_NAME, locale, ClassLoader.getSystemClassLoader());
                }
                catch (MissingResourceException missingResourceException) {
                    throw new InternalError(missingResourceException.toString());
                }
            }
        });
    }

    private synchronized ResourceBundle findResourceBundle(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        Locale locale = Locale.getDefault();
        if (this.catalog != null && locale.equals(this.catalogLocale) && string.equals(this.catalogName)) {
            return this.catalog;
        }
        if (string.equals(SYSTEM_LOGGER_RB_NAME)) {
            this.catalog = Logger.findSystemResourceBundle(locale);
            this.catalogName = string;
            this.catalogLocale = locale;
            return this.catalog;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            this.catalog = ResourceBundle.getBundle(string, locale, classLoader);
            this.catalogName = string;
            this.catalogLocale = locale;
            return this.catalog;
        }
        catch (MissingResourceException missingResourceException) {
            ClassLoader classLoader2;
            if (bl && (classLoader2 = this.getCallersClassLoader()) != null && classLoader2 != classLoader) {
                try {
                    this.catalog = ResourceBundle.getBundle(string, locale, classLoader2);
                    this.catalogName = string;
                    this.catalogLocale = locale;
                    return this.catalog;
                }
                catch (MissingResourceException missingResourceException2) {
                    // empty catch block
                }
            }
            if (LoggerHelper.allowStackWalkSearch) {
                return this.findResourceBundleFromStack(string, locale, classLoader);
            }
            return null;
        }
    }

    @CallerSensitive
    private synchronized ResourceBundle findResourceBundleFromStack(String string, Locale locale, ClassLoader classLoader) {
        Class clazz;
        int n = 0;
        while ((clazz = Reflection.getCallerClass(n)) != null) {
            ClassLoader classLoader2 = clazz.getClassLoader();
            if (classLoader2 == null) {
                classLoader2 = ClassLoader.getSystemClassLoader();
            }
            if (classLoader != classLoader2) {
                classLoader = classLoader2;
                try {
                    this.catalog = ResourceBundle.getBundle(string, locale, classLoader);
                    this.catalogName = string;
                    this.catalogLocale = locale;
                    return this.catalog;
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            ++n;
        }
        return null;
    }

    private synchronized void setupResourceInfo(String string, Class<?> clazz) {
        if (string == null) {
            return;
        }
        this.setCallersClassLoaderRef(clazz);
        if (this.isSystemLogger && this.getCallersClassLoader() != null) {
            this.checkPermission();
        }
        if (this.findResourceBundle(string, true) == null) {
            this.callersClassLoaderRef = null;
            throw new MissingResourceException("Can't find " + string + " bundle", string, "");
        }
        this.resourceBundleName = string;
    }

    public Logger getParent() {
        return this.parent;
    }

    public void setParent(Logger logger) {
        if (logger == null) {
            throw new NullPointerException();
        }
        if (this.manager == null) {
            this.manager = LogManager.getLogManager();
        }
        this.manager.checkPermission();
        this.doSetParent(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetParent(Logger logger) {
        Object object = treeLock;
        synchronized (object) {
            LogManager.LoggerWeakRef loggerWeakRef = null;
            if (this.parent != null) {
                Iterator<LogManager.LoggerWeakRef> iterator = this.parent.kids.iterator();
                while (iterator.hasNext()) {
                    loggerWeakRef = iterator.next();
                    Logger logger2 = (Logger)loggerWeakRef.get();
                    if (logger2 == this) {
                        iterator.remove();
                        break;
                    }
                    loggerWeakRef = null;
                }
            }
            this.parent = logger;
            if (this.parent.kids == null) {
                this.parent.kids = new ArrayList(2);
            }
            if (loggerWeakRef == null) {
                LogManager logManager = this.manager;
                logManager.getClass();
                loggerWeakRef = logManager.new LogManager.LoggerWeakRef(this);
            }
            loggerWeakRef.setParentRef(new WeakReference<Logger>(this.parent));
            this.parent.kids.add(loggerWeakRef);
            this.updateEffectiveLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeChildLogger(LogManager.LoggerWeakRef loggerWeakRef) {
        Object object = treeLock;
        synchronized (object) {
            Iterator<LogManager.LoggerWeakRef> iterator = this.kids.iterator();
            while (iterator.hasNext()) {
                LogManager.LoggerWeakRef loggerWeakRef2 = iterator.next();
                if (loggerWeakRef2 != loggerWeakRef) continue;
                iterator.remove();
                return;
            }
        }
    }

    private void updateEffectiveLevel() {
        int n = this.levelObject != null ? this.levelObject.intValue() : (this.parent != null ? this.parent.levelValue : Level.INFO.intValue());
        if (this.levelValue == n) {
            return;
        }
        this.levelValue = n;
        if (this.kids != null) {
            for (int i = 0; i < this.kids.size(); ++i) {
                LogManager.LoggerWeakRef loggerWeakRef = this.kids.get(i);
                Logger logger = (Logger)loggerWeakRef.get();
                if (logger == null) continue;
                logger.updateEffectiveLevel();
            }
        }
    }

    private String getEffectiveResourceBundleName() {
        Logger logger = this;
        while (logger != null) {
            String string;
            String string2 = this.isSystemLogger ? (logger.isSystemLogger ? logger.resourceBundleName : null) : (string = logger.getResourceBundleName());
            if (string != null) {
                return string;
            }
            logger = this.isSystemLogger ? logger.parent : logger.getParent();
        }
        return null;
    }

    private static class LoggerHelper {
        static boolean disableCallerCheck = LoggerHelper.getBooleanProperty("sun.util.logging.disableCallerCheck");
        static boolean allowStackWalkSearch = LoggerHelper.getBooleanProperty("jdk.logging.allowStackWalkSearch");

        private LoggerHelper() {
        }

        private static boolean getBooleanProperty(final String string) {
            String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(string);
                }
            });
            return Boolean.valueOf(string2);
        }
    }
}

