/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.comparator;

import java.util.Comparator;
import org.springframework.util.Assert;
import org.springframework.util.comparator.ComparableComparator;

public class NullSafeComparator
implements Comparator {
    public static final NullSafeComparator NULLS_LOW = new NullSafeComparator(true);
    public static final NullSafeComparator NULLS_HIGH = new NullSafeComparator(false);
    private final Comparator nonNullComparator;
    private final boolean nullsLow;

    private NullSafeComparator(boolean bl) {
        this(new ComparableComparator(), bl);
    }

    public NullSafeComparator(Comparator comparator, boolean bl) {
        Assert.notNull(comparator, "The non-null comparator is required");
        this.nonNullComparator = comparator;
        this.nullsLow = bl;
    }

    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return this.nullsLow ? -1 : 1;
        }
        if (object2 == null) {
            return this.nullsLow ? 1 : -1;
        }
        return this.nonNullComparator.compare(object, object2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NullSafeComparator)) {
            return false;
        }
        NullSafeComparator nullSafeComparator = (NullSafeComparator)object;
        return ((Object)this.nonNullComparator).equals(nullSafeComparator.nonNullComparator) && this.nullsLow == nullSafeComparator.nullsLow;
    }

    public int hashCode() {
        return (this.nullsLow ? -1 : 1) * this.nonNullComparator.hashCode();
    }

    public String toString() {
        return "NullSafeComparator: non-null comparator [" + this.nonNullComparator + "]; " + (this.nullsLow ? "nulls low" : "nulls high");
    }
}

